package org.graylog.plugins.map.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GeoIpResolverConfig extends GeoIpResolverConfig {

  private final boolean enabled;

  private final DatabaseType dbType;

  private final String dbPath;

  private AutoValue_GeoIpResolverConfig(
      boolean enabled,
      DatabaseType dbType,
      String dbPath) {
    this.enabled = enabled;
    this.dbType = dbType;
    this.dbPath = dbPath;
  }

  @JsonProperty("enabled")
  @Override
  public boolean enabled() {
    return enabled;
  }

  @JsonProperty("db_type")
  @Override
  public DatabaseType dbType() {
    return dbType;
  }

  @JsonProperty("db_path")
  @Override
  public String dbPath() {
    return dbPath;
  }

  @Override
  public String toString() {
    return "GeoIpResolverConfig{"
        + "enabled=" + enabled + ", "
        + "dbType=" + dbType + ", "
        + "dbPath=" + dbPath
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GeoIpResolverConfig) {
      GeoIpResolverConfig that = (GeoIpResolverConfig) o;
      return this.enabled == that.enabled()
          && this.dbType.equals(that.dbType())
          && this.dbPath.equals(that.dbPath());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= enabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= dbType.hashCode();
    h$ *= 1000003;
    h$ ^= dbPath.hashCode();
    return h$;
  }

  @Override
  public GeoIpResolverConfig.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GeoIpResolverConfig.Builder {
    private Boolean enabled;
    private DatabaseType dbType;
    private String dbPath;
    Builder() {
    }
    private Builder(GeoIpResolverConfig source) {
      this.enabled = source.enabled();
      this.dbType = source.dbType();
      this.dbPath = source.dbPath();
    }
    @Override
    public GeoIpResolverConfig.Builder enabled(boolean enabled) {
      this.enabled = enabled;
      return this;
    }
    @Override
    public GeoIpResolverConfig.Builder dbType(DatabaseType dbType) {
      if (dbType == null) {
        throw new NullPointerException("Null dbType");
      }
      this.dbType = dbType;
      return this;
    }
    @Override
    public GeoIpResolverConfig.Builder dbPath(String dbPath) {
      if (dbPath == null) {
        throw new NullPointerException("Null dbPath");
      }
      this.dbPath = dbPath;
      return this;
    }
    @Override
    public GeoIpResolverConfig build() {
      String missing = "";
      if (this.enabled == null) {
        missing += " enabled";
      }
      if (this.dbType == null) {
        missing += " dbType";
      }
      if (this.dbPath == null) {
        missing += " dbPath";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GeoIpResolverConfig(
          this.enabled,
          this.dbType,
          this.dbPath);
    }
  }

}
