package org.graylog.plugins.map.geoip;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.graylog.plugins.map.config.DatabaseType;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_MaxmindDataAdapter_Config extends MaxmindDataAdapter.Config {

  private final String type;

  private final @NotEmpty String path;

  private final @NotNull DatabaseType dbType;

  private final @Min(0L) long checkInterval;

  private final TimeUnit checkIntervalUnit;

  $AutoValue_MaxmindDataAdapter_Config(
      String type,
      @NotEmpty String path,
      @NotNull DatabaseType dbType,
      @Min(0L) long checkInterval,
      @Nullable TimeUnit checkIntervalUnit) {
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (path == null) {
      throw new NullPointerException("Null path");
    }
    this.path = path;
    if (dbType == null) {
      throw new NullPointerException("Null dbType");
    }
    this.dbType = dbType;
    this.checkInterval = checkInterval;
    this.checkIntervalUnit = checkIntervalUnit;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("path")
  @Override
  public @NotEmpty String path() {
    return path;
  }

  @JsonProperty("database_type")
  @Override
  public @NotNull DatabaseType dbType() {
    return dbType;
  }

  @JsonProperty("check_interval")
  @Override
  public @Min(0L) long checkInterval() {
    return checkInterval;
  }

  @Nullable
  @JsonProperty("check_interval_unit")
  @Override
  public TimeUnit checkIntervalUnit() {
    return checkIntervalUnit;
  }

  @Override
  public String toString() {
    return "Config{"
        + "type=" + type + ", "
        + "path=" + path + ", "
        + "dbType=" + dbType + ", "
        + "checkInterval=" + checkInterval + ", "
        + "checkIntervalUnit=" + checkIntervalUnit
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MaxmindDataAdapter.Config) {
      MaxmindDataAdapter.Config that = (MaxmindDataAdapter.Config) o;
      return this.type.equals(that.type())
          && this.path.equals(that.path())
          && this.dbType.equals(that.dbType())
          && this.checkInterval == that.checkInterval()
          && (this.checkIntervalUnit == null ? that.checkIntervalUnit() == null : this.checkIntervalUnit.equals(that.checkIntervalUnit()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= path.hashCode();
    h$ *= 1000003;
    h$ ^= dbType.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((checkInterval >>> 32) ^ checkInterval);
    h$ *= 1000003;
    h$ ^= (checkIntervalUnit == null) ? 0 : checkIntervalUnit.hashCode();
    return h$;
  }

  static class Builder extends MaxmindDataAdapter.Config.Builder {
    private String type;
    private @NotEmpty String path;
    private @NotNull DatabaseType dbType;
    private Long checkInterval;
    private TimeUnit checkIntervalUnit;
    Builder() {
    }
    @Override
    public MaxmindDataAdapter.Config.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public MaxmindDataAdapter.Config.Builder path(String path) {
      if (path == null) {
        throw new NullPointerException("Null path");
      }
      this.path = path;
      return this;
    }
    @Override
    public MaxmindDataAdapter.Config.Builder dbType(DatabaseType dbType) {
      if (dbType == null) {
        throw new NullPointerException("Null dbType");
      }
      this.dbType = dbType;
      return this;
    }
    @Override
    public MaxmindDataAdapter.Config.Builder checkInterval(long checkInterval) {
      this.checkInterval = checkInterval;
      return this;
    }
    @Override
    public MaxmindDataAdapter.Config.Builder checkIntervalUnit(@Nullable TimeUnit checkIntervalUnit) {
      this.checkIntervalUnit = checkIntervalUnit;
      return this;
    }
    @Override
    public MaxmindDataAdapter.Config build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.path == null) {
        missing += " path";
      }
      if (this.dbType == null) {
        missing += " dbType";
      }
      if (this.checkInterval == null) {
        missing += " checkInterval";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MaxmindDataAdapter_Config(
          this.type,
          this.path,
          this.dbType,
          this.checkInterval,
          this.checkIntervalUnit);
    }
  }

}
