package org.graylog.plugins.map.geoip;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GeoIpResolverEngine_GeoLocationInformation extends GeoIpResolverEngine.GeoLocationInformation {

  private final double latitude;

  private final double longitude;

  private final String countryIsoCode;

  private final String cityName;

  AutoValue_GeoIpResolverEngine_GeoLocationInformation(
      double latitude,
      double longitude,
      String countryIsoCode,
      String cityName) {
    this.latitude = latitude;
    this.longitude = longitude;
    if (countryIsoCode == null) {
      throw new NullPointerException("Null countryIsoCode");
    }
    this.countryIsoCode = countryIsoCode;
    if (cityName == null) {
      throw new NullPointerException("Null cityName");
    }
    this.cityName = cityName;
  }

  @Override
  public double latitude() {
    return latitude;
  }

  @Override
  public double longitude() {
    return longitude;
  }

  @Override
  public String countryIsoCode() {
    return countryIsoCode;
  }

  @Override
  public String cityName() {
    return cityName;
  }

  @Override
  public String toString() {
    return "GeoLocationInformation{"
        + "latitude=" + latitude + ", "
        + "longitude=" + longitude + ", "
        + "countryIsoCode=" + countryIsoCode + ", "
        + "cityName=" + cityName
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GeoIpResolverEngine.GeoLocationInformation) {
      GeoIpResolverEngine.GeoLocationInformation that = (GeoIpResolverEngine.GeoLocationInformation) o;
      return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(that.latitude())
          && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(that.longitude())
          && this.countryIsoCode.equals(that.countryIsoCode())
          && this.cityName.equals(that.cityName());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(latitude) >>> 32) ^ Double.doubleToLongBits(latitude));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(longitude) >>> 32) ^ Double.doubleToLongBits(longitude));
    h$ *= 1000003;
    h$ ^= countryIsoCode.hashCode();
    h$ *= 1000003;
    h$ ^= cityName.hashCode();
    return h$;
  }

}
