package org.graylog.plugins.map.geoip;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.graylog.plugins.map.config.DatabaseType;

final class AutoValue_MaxmindDataAdapter_Config extends $AutoValue_MaxmindDataAdapter_Config {
  AutoValue_MaxmindDataAdapter_Config(String type, String path, DatabaseType dbType,
      long checkInterval, TimeUnit checkIntervalUnit) {
    super(type, path, dbType, checkInterval, checkIntervalUnit);
  }

  @JsonIgnore
  public final String getType() {
    return type();
  }

  @JsonIgnore
  @NotEmpty
  public final String getPath() {
    return path();
  }

  @JsonIgnore
  @NotNull
  public final DatabaseType getDbType() {
    return dbType();
  }

  @JsonIgnore
  @Min(0)
  public final long getCheckInterval() {
    return checkInterval();
  }

  @JsonIgnore
  @Nullable
  public final TimeUnit getCheckIntervalUnit() {
    return checkIntervalUnit();
  }
}
