package org.graylog.plugins.netflow.v9;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_NetFlowV9Packet extends NetFlowV9Packet {

  private final NetFlowV9Header header;

  private final ImmutableList<NetFlowV9Template> templates;

  private final NetFlowV9OptionTemplate optionTemplate;

  private final ImmutableList<NetFlowV9BaseRecord> records;

  private final long dataLength;

  AutoValue_NetFlowV9Packet(
      NetFlowV9Header header,
      ImmutableList<NetFlowV9Template> templates,
      @Nullable NetFlowV9OptionTemplate optionTemplate,
      ImmutableList<NetFlowV9BaseRecord> records,
      long dataLength) {
    if (header == null) {
      throw new NullPointerException("Null header");
    }
    this.header = header;
    if (templates == null) {
      throw new NullPointerException("Null templates");
    }
    this.templates = templates;
    this.optionTemplate = optionTemplate;
    if (records == null) {
      throw new NullPointerException("Null records");
    }
    this.records = records;
    this.dataLength = dataLength;
  }

  @Override
  public NetFlowV9Header header() {
    return header;
  }

  @Override
  public ImmutableList<NetFlowV9Template> templates() {
    return templates;
  }

  @Nullable
  @Override
  public NetFlowV9OptionTemplate optionTemplate() {
    return optionTemplate;
  }

  @Override
  public ImmutableList<NetFlowV9BaseRecord> records() {
    return records;
  }

  @Override
  public long dataLength() {
    return dataLength;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NetFlowV9Packet) {
      NetFlowV9Packet that = (NetFlowV9Packet) o;
      return this.header.equals(that.header())
          && this.templates.equals(that.templates())
          && (this.optionTemplate == null ? that.optionTemplate() == null : this.optionTemplate.equals(that.optionTemplate()))
          && this.records.equals(that.records())
          && this.dataLength == that.dataLength();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= header.hashCode();
    h$ *= 1000003;
    h$ ^= templates.hashCode();
    h$ *= 1000003;
    h$ ^= (optionTemplate == null) ? 0 : optionTemplate.hashCode();
    h$ *= 1000003;
    h$ ^= records.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((dataLength >>> 32) ^ dataLength);
    return h$;
  }

}
