package org.graylog.plugins.pipelineprocessor.ast;

import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LogicalExpression;
import org.graylog.plugins.pipelineprocessor.ast.statements.Statement;
import org.graylog.plugins.pipelineprocessor.codegen.GeneratedRule;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Rule extends Rule {

  private final String id;

  private final String name;

  private final LogicalExpression when;

  private final Collection<Statement> then;

  private final Class<? extends GeneratedRule> generatedRuleClass;

  private final GeneratedRule generatedRule;

  private AutoValue_Rule(
      @Nullable String id,
      String name,
      LogicalExpression when,
      Collection<Statement> then,
      @Nullable Class<? extends GeneratedRule> generatedRuleClass,
      @Nullable GeneratedRule generatedRule) {
    this.id = id;
    this.name = name;
    this.when = when;
    this.then = then;
    this.generatedRuleClass = generatedRuleClass;
    this.generatedRule = generatedRule;
  }

  @Nullable
  @Override
  public String id() {
    return id;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public LogicalExpression when() {
    return when;
  }

  @Override
  public Collection<Statement> then() {
    return then;
  }

  @Nullable
  @Override
  public Class<? extends GeneratedRule> generatedRuleClass() {
    return generatedRuleClass;
  }

  @Nullable
  @Override
  public GeneratedRule generatedRule() {
    return generatedRule;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Rule) {
      Rule that = (Rule) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.name.equals(that.name())
          && this.when.equals(that.when())
          && this.then.equals(that.then())
          && (this.generatedRuleClass == null ? that.generatedRuleClass() == null : this.generatedRuleClass.equals(that.generatedRuleClass()))
          && (this.generatedRule == null ? that.generatedRule() == null : this.generatedRule.equals(that.generatedRule()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= when.hashCode();
    h$ *= 1000003;
    h$ ^= then.hashCode();
    h$ *= 1000003;
    h$ ^= (generatedRuleClass == null) ? 0 : generatedRuleClass.hashCode();
    h$ *= 1000003;
    h$ ^= (generatedRule == null) ? 0 : generatedRule.hashCode();
    return h$;
  }

  @Override
  public Rule.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Rule.Builder {
    private String id;
    private String name;
    private LogicalExpression when;
    private Collection<Statement> then;
    private Class<? extends GeneratedRule> generatedRuleClass;
    private GeneratedRule generatedRule;
    Builder() {
    }
    private Builder(Rule source) {
      this.id = source.id();
      this.name = source.name();
      this.when = source.when();
      this.then = source.then();
      this.generatedRuleClass = source.generatedRuleClass();
      this.generatedRule = source.generatedRule();
    }
    @Override
    public Rule.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public Rule.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public Rule.Builder when(LogicalExpression when) {
      if (when == null) {
        throw new NullPointerException("Null when");
      }
      this.when = when;
      return this;
    }
    @Override
    public Rule.Builder then(Collection<Statement> then) {
      if (then == null) {
        throw new NullPointerException("Null then");
      }
      this.then = then;
      return this;
    }
    @Override
    public Rule.Builder generatedRuleClass(@Nullable Class<? extends GeneratedRule> generatedRuleClass) {
      this.generatedRuleClass = generatedRuleClass;
      return this;
    }
    @Override
    public Rule.Builder generatedRule(GeneratedRule generatedRule) {
      this.generatedRule = generatedRule;
      return this;
    }
    @Override
    public Rule build() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.when == null) {
        missing += " when";
      }
      if (this.then == null) {
        missing += " then";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Rule(
          this.id,
          this.name,
          this.when,
          this.then,
          this.generatedRuleClass,
          this.generatedRule);
    }
  }

}
