package org.graylog.plugins.pipelineprocessor.ast.functions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FunctionDescriptor<T> extends FunctionDescriptor<T> {

  private final String name;

  private final boolean pure;

  private final Class<? extends T> returnType;

  private final ImmutableList<ParameterDescriptor> params;

  private final ImmutableMap<String, ParameterDescriptor> paramMap;

  private final String description;

  private AutoValue_FunctionDescriptor(
      String name,
      boolean pure,
      Class<? extends T> returnType,
      ImmutableList<ParameterDescriptor> params,
      ImmutableMap<String, ParameterDescriptor> paramMap,
      @Nullable String description) {
    this.name = name;
    this.pure = pure;
    this.returnType = returnType;
    this.params = params;
    this.paramMap = paramMap;
    this.description = description;
  }

  @JsonProperty
  @Override
  public String name() {
    return name;
  }

  @JsonProperty
  @Override
  public boolean pure() {
    return pure;
  }

  @JsonProperty
  @Override
  public Class<? extends T> returnType() {
    return returnType;
  }

  @JsonProperty
  @Override
  public ImmutableList<ParameterDescriptor> params() {
    return params;
  }

  @JsonIgnore
  @Override
  public ImmutableMap<String, ParameterDescriptor> paramMap() {
    return paramMap;
  }

  @JsonProperty
  @Nullable
  @Override
  public String description() {
    return description;
  }

  @Override
  public String toString() {
    return "FunctionDescriptor{"
        + "name=" + name + ", "
        + "pure=" + pure + ", "
        + "returnType=" + returnType + ", "
        + "params=" + params + ", "
        + "paramMap=" + paramMap + ", "
        + "description=" + description
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FunctionDescriptor) {
      FunctionDescriptor<?> that = (FunctionDescriptor<?>) o;
      return this.name.equals(that.name())
          && this.pure == that.pure()
          && this.returnType.equals(that.returnType())
          && this.params.equals(that.params())
          && this.paramMap.equals(that.paramMap())
          && (this.description == null ? that.description() == null : this.description.equals(that.description()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= pure ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= returnType.hashCode();
    h$ *= 1000003;
    h$ ^= params.hashCode();
    h$ *= 1000003;
    h$ ^= paramMap.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    return h$;
  }

  static final class Builder<T> extends FunctionDescriptor.Builder<T> {
    private String name;
    private Boolean pure;
    private Class<? extends T> returnType;
    private ImmutableList<ParameterDescriptor> params;
    private ImmutableMap<String, ParameterDescriptor> paramMap;
    private String description;
    Builder() {
    }
    @Override
    public FunctionDescriptor.Builder<T> name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public FunctionDescriptor.Builder<T> pure(boolean pure) {
      this.pure = pure;
      return this;
    }
    @Override
    public FunctionDescriptor.Builder<T> returnType(Class<? extends T> returnType) {
      if (returnType == null) {
        throw new NullPointerException("Null returnType");
      }
      this.returnType = returnType;
      return this;
    }
    @Override
    public FunctionDescriptor.Builder<T> params(ImmutableList<ParameterDescriptor> params) {
      if (params == null) {
        throw new NullPointerException("Null params");
      }
      this.params = params;
      return this;
    }
    @Override
    public ImmutableList<ParameterDescriptor> params() {
      if (params == null) {
        throw new IllegalStateException("Property \"params\" has not been set");
      }
      return params;
    }
    @Override
    public FunctionDescriptor.Builder<T> paramMap(ImmutableMap<String, ParameterDescriptor> paramMap) {
      if (paramMap == null) {
        throw new NullPointerException("Null paramMap");
      }
      this.paramMap = paramMap;
      return this;
    }
    @Override
    public FunctionDescriptor.Builder<T> description(@Nullable String description) {
      this.description = description;
      return this;
    }
    @Override
    FunctionDescriptor<T> autoBuild() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.pure == null) {
        missing += " pure";
      }
      if (this.returnType == null) {
        missing += " returnType";
      }
      if (this.params == null) {
        missing += " params";
      }
      if (this.paramMap == null) {
        missing += " paramMap";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FunctionDescriptor<T>(
          this.name,
          this.pure,
          this.returnType,
          this.params,
          this.paramMap,
          this.description);
    }
  }

}
