package org.graylog.plugins.pipelineprocessor.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.parser.errors.ParseError;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PipelineSource extends PipelineSource {

  private final String id;

  private final String title;

  private final String description;

  private final String source;

  private final DateTime createdAt;

  private final DateTime modifiedAt;

  private final List<StageSource> stages;

  private final Set<ParseError> errors;

  private AutoValue_PipelineSource(
      @Nullable String id,
      @Nullable String title,
      @Nullable String description,
      String source,
      @Nullable DateTime createdAt,
      @Nullable DateTime modifiedAt,
      List<StageSource> stages,
      @Nullable Set<ParseError> errors) {
    this.id = id;
    this.title = title;
    this.description = description;
    this.source = source;
    this.createdAt = createdAt;
    this.modifiedAt = modifiedAt;
    this.stages = stages;
    this.errors = errors;
  }

  @JsonProperty("id")
  @Nullable
  @Id
  @ObjectId
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("title")
  @Nullable
  @Override
  public String title() {
    return title;
  }

  @JsonProperty("description")
  @Nullable
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("source")
  @Override
  public String source() {
    return source;
  }

  @JsonProperty("created_at")
  @Nullable
  @Override
  public DateTime createdAt() {
    return createdAt;
  }

  @JsonProperty("modified_at")
  @Nullable
  @Override
  public DateTime modifiedAt() {
    return modifiedAt;
  }

  @JsonProperty("stages")
  @Override
  public List<StageSource> stages() {
    return stages;
  }

  @JsonProperty("errors")
  @Nullable
  @Override
  public Set<ParseError> errors() {
    return errors;
  }

  @Override
  public String toString() {
    return "PipelineSource{"
        + "id=" + id + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "source=" + source + ", "
        + "createdAt=" + createdAt + ", "
        + "modifiedAt=" + modifiedAt + ", "
        + "stages=" + stages + ", "
        + "errors=" + errors
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PipelineSource) {
      PipelineSource that = (PipelineSource) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && (this.title == null ? that.title() == null : this.title.equals(that.title()))
          && (this.description == null ? that.description() == null : this.description.equals(that.description()))
          && this.source.equals(that.source())
          && (this.createdAt == null ? that.createdAt() == null : this.createdAt.equals(that.createdAt()))
          && (this.modifiedAt == null ? that.modifiedAt() == null : this.modifiedAt.equals(that.modifiedAt()))
          && this.stages.equals(that.stages())
          && (this.errors == null ? that.errors() == null : this.errors.equals(that.errors()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= (title == null) ? 0 : title.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= source.hashCode();
    h$ *= 1000003;
    h$ ^= (createdAt == null) ? 0 : createdAt.hashCode();
    h$ *= 1000003;
    h$ ^= (modifiedAt == null) ? 0 : modifiedAt.hashCode();
    h$ *= 1000003;
    h$ ^= stages.hashCode();
    h$ *= 1000003;
    h$ ^= (errors == null) ? 0 : errors.hashCode();
    return h$;
  }

  @Override
  public PipelineSource.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends PipelineSource.Builder {
    private String id;
    private String title;
    private String description;
    private String source;
    private DateTime createdAt;
    private DateTime modifiedAt;
    private List<StageSource> stages;
    private Set<ParseError> errors;
    Builder() {
    }
    private Builder(PipelineSource source) {
      this.id = source.id();
      this.title = source.title();
      this.description = source.description();
      this.source = source.source();
      this.createdAt = source.createdAt();
      this.modifiedAt = source.modifiedAt();
      this.stages = source.stages();
      this.errors = source.errors();
    }
    @Override
    public PipelineSource.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public PipelineSource.Builder title(String title) {
      this.title = title;
      return this;
    }
    @Override
    public PipelineSource.Builder description(String description) {
      this.description = description;
      return this;
    }
    @Override
    public PipelineSource.Builder source(String source) {
      if (source == null) {
        throw new NullPointerException("Null source");
      }
      this.source = source;
      return this;
    }
    @Override
    public PipelineSource.Builder createdAt(DateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }
    @Override
    public PipelineSource.Builder modifiedAt(DateTime modifiedAt) {
      this.modifiedAt = modifiedAt;
      return this;
    }
    @Override
    public PipelineSource.Builder stages(List<StageSource> stages) {
      if (stages == null) {
        throw new NullPointerException("Null stages");
      }
      this.stages = stages;
      return this;
    }
    @Override
    public PipelineSource.Builder errors(Set<ParseError> errors) {
      this.errors = errors;
      return this;
    }
    @Override
    public PipelineSource build() {
      String missing = "";
      if (this.source == null) {
        missing += " source";
      }
      if (this.stages == null) {
        missing += " stages";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PipelineSource(
          this.id,
          this.title,
          this.description,
          this.source,
          this.createdAt,
          this.modifiedAt,
          this.stages,
          this.errors);
    }
  }

}
