package org.graylog.plugins.pipelineprocessor.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SimulationRequest extends SimulationRequest {

  private final String streamId;

  private final Map<String, Object> message;

  private final String inputId;

  private AutoValue_SimulationRequest(
      String streamId,
      Map<String, Object> message,
      @Nullable String inputId) {
    this.streamId = streamId;
    this.message = message;
    this.inputId = inputId;
  }

  @JsonProperty
  @Override
  public String streamId() {
    return streamId;
  }

  @JsonProperty
  @Override
  public Map<String, Object> message() {
    return message;
  }

  @JsonProperty
  @Nullable
  @Override
  public String inputId() {
    return inputId;
  }

  @Override
  public String toString() {
    return "SimulationRequest{"
        + "streamId=" + streamId + ", "
        + "message=" + message + ", "
        + "inputId=" + inputId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SimulationRequest) {
      SimulationRequest that = (SimulationRequest) o;
      return this.streamId.equals(that.streamId())
          && this.message.equals(that.message())
          && (this.inputId == null ? that.inputId() == null : this.inputId.equals(that.inputId()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= streamId.hashCode();
    h$ *= 1000003;
    h$ ^= message.hashCode();
    h$ *= 1000003;
    h$ ^= (inputId == null) ? 0 : inputId.hashCode();
    return h$;
  }

  static final class Builder extends SimulationRequest.Builder {
    private String streamId;
    private Map<String, Object> message;
    private String inputId;
    Builder() {
    }
    @Override
    public SimulationRequest.Builder streamId(String streamId) {
      if (streamId == null) {
        throw new NullPointerException("Null streamId");
      }
      this.streamId = streamId;
      return this;
    }
    @Override
    public SimulationRequest.Builder message(Map<String, Object> message) {
      if (message == null) {
        throw new NullPointerException("Null message");
      }
      this.message = message;
      return this;
    }
    @Override
    public SimulationRequest.Builder inputId(String inputId) {
      this.inputId = inputId;
      return this;
    }
    @Override
    public SimulationRequest build() {
      String missing = "";
      if (this.streamId == null) {
        missing += " streamId";
      }
      if (this.message == null) {
        missing += " message";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SimulationRequest(
          this.streamId,
          this.message,
          this.inputId);
    }
  }

}
