package org.graylog.plugins.sidecar.rest.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Collector extends Collector {

  private final String id;

  private final String name;

  private final String serviceType;

  private final String nodeOperatingSystem;

  private final String executablePath;

  private final String executeParameters;

  private final String validationParameters;

  private final String defaultTemplate;

  private AutoValue_Collector(
      @Nullable String id,
      String name,
      String serviceType,
      String nodeOperatingSystem,
      String executablePath,
      @Nullable String executeParameters,
      @Nullable String validationParameters,
      @Nullable String defaultTemplate) {
    this.id = id;
    this.name = name;
    this.serviceType = serviceType;
    this.nodeOperatingSystem = nodeOperatingSystem;
    this.executablePath = executablePath;
    this.executeParameters = executeParameters;
    this.validationParameters = validationParameters;
    this.defaultTemplate = defaultTemplate;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  @JsonProperty("service_type")
  @Override
  public String serviceType() {
    return serviceType;
  }

  @JsonProperty("node_operating_system")
  @Override
  public String nodeOperatingSystem() {
    return nodeOperatingSystem;
  }

  @JsonProperty("executable_path")
  @Override
  public String executablePath() {
    return executablePath;
  }

  @JsonProperty("execute_parameters")
  @Nullable
  @Override
  public String executeParameters() {
    return executeParameters;
  }

  @JsonProperty("validation_parameters")
  @Nullable
  @Override
  public String validationParameters() {
    return validationParameters;
  }

  @JsonProperty("default_template")
  @Nullable
  @Override
  public String defaultTemplate() {
    return defaultTemplate;
  }

  @Override
  public String toString() {
    return "Collector{"
        + "id=" + id + ", "
        + "name=" + name + ", "
        + "serviceType=" + serviceType + ", "
        + "nodeOperatingSystem=" + nodeOperatingSystem + ", "
        + "executablePath=" + executablePath + ", "
        + "executeParameters=" + executeParameters + ", "
        + "validationParameters=" + validationParameters + ", "
        + "defaultTemplate=" + defaultTemplate
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Collector) {
      Collector that = (Collector) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.name.equals(that.name())
          && this.serviceType.equals(that.serviceType())
          && this.nodeOperatingSystem.equals(that.nodeOperatingSystem())
          && this.executablePath.equals(that.executablePath())
          && (this.executeParameters == null ? that.executeParameters() == null : this.executeParameters.equals(that.executeParameters()))
          && (this.validationParameters == null ? that.validationParameters() == null : this.validationParameters.equals(that.validationParameters()))
          && (this.defaultTemplate == null ? that.defaultTemplate() == null : this.defaultTemplate.equals(that.defaultTemplate()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= serviceType.hashCode();
    h$ *= 1000003;
    h$ ^= nodeOperatingSystem.hashCode();
    h$ *= 1000003;
    h$ ^= executablePath.hashCode();
    h$ *= 1000003;
    h$ ^= (executeParameters == null) ? 0 : executeParameters.hashCode();
    h$ *= 1000003;
    h$ ^= (validationParameters == null) ? 0 : validationParameters.hashCode();
    h$ *= 1000003;
    h$ ^= (defaultTemplate == null) ? 0 : defaultTemplate.hashCode();
    return h$;
  }

  @Override
  public Collector.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Collector.Builder {
    private String id;
    private String name;
    private String serviceType;
    private String nodeOperatingSystem;
    private String executablePath;
    private String executeParameters;
    private String validationParameters;
    private String defaultTemplate;
    Builder() {
    }
    private Builder(Collector source) {
      this.id = source.id();
      this.name = source.name();
      this.serviceType = source.serviceType();
      this.nodeOperatingSystem = source.nodeOperatingSystem();
      this.executablePath = source.executablePath();
      this.executeParameters = source.executeParameters();
      this.validationParameters = source.validationParameters();
      this.defaultTemplate = source.defaultTemplate();
    }
    @Override
    public Collector.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public Collector.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public Collector.Builder serviceType(String serviceType) {
      if (serviceType == null) {
        throw new NullPointerException("Null serviceType");
      }
      this.serviceType = serviceType;
      return this;
    }
    @Override
    public Collector.Builder nodeOperatingSystem(String nodeOperatingSystem) {
      if (nodeOperatingSystem == null) {
        throw new NullPointerException("Null nodeOperatingSystem");
      }
      this.nodeOperatingSystem = nodeOperatingSystem;
      return this;
    }
    @Override
    public Collector.Builder executablePath(String executablePath) {
      if (executablePath == null) {
        throw new NullPointerException("Null executablePath");
      }
      this.executablePath = executablePath;
      return this;
    }
    @Override
    public Collector.Builder executeParameters(String executeParameters) {
      this.executeParameters = executeParameters;
      return this;
    }
    @Override
    public Collector.Builder validationParameters(String validationParameters) {
      this.validationParameters = validationParameters;
      return this;
    }
    @Override
    public Collector.Builder defaultTemplate(String defaultTemplate) {
      this.defaultTemplate = defaultTemplate;
      return this;
    }
    @Override
    public Collector build() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.serviceType == null) {
        missing += " serviceType";
      }
      if (this.nodeOperatingSystem == null) {
        missing += " nodeOperatingSystem";
      }
      if (this.executablePath == null) {
        missing += " executablePath";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Collector(
          this.id,
          this.name,
          this.serviceType,
          this.nodeOperatingSystem,
          this.executablePath,
          this.executeParameters,
          this.validationParameters,
          this.defaultTemplate);
    }
  }

}
