package org.graylog.plugins.sidecar.rest.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CollectorUpload extends CollectorUpload {

  private final String id;

  private final String collectorId;

  private final String nodeId;

  private final String collectorName;

  private final String renderedConfiguration;

  private final DateTime created;

  private AutoValue_CollectorUpload(
      @Nullable String id,
      String collectorId,
      String nodeId,
      String collectorName,
      String renderedConfiguration,
      @Nullable DateTime created) {
    this.id = id;
    this.collectorId = collectorId;
    this.nodeId = nodeId;
    this.collectorName = collectorName;
    this.renderedConfiguration = renderedConfiguration;
    this.created = created;
  }

  @JsonProperty("id")
  @Id
  @ObjectId
  @Nullable
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("collector_id")
  @Override
  public String collectorId() {
    return collectorId;
  }

  @JsonProperty("node_id")
  @Override
  public String nodeId() {
    return nodeId;
  }

  @JsonProperty("collector_name")
  @Override
  public String collectorName() {
    return collectorName;
  }

  @JsonProperty("rendered_configuration")
  @Override
  public String renderedConfiguration() {
    return renderedConfiguration;
  }

  @JsonProperty("created")
  @Nullable
  @Override
  public DateTime created() {
    return created;
  }

  @Override
  public String toString() {
    return "CollectorUpload{"
        + "id=" + id + ", "
        + "collectorId=" + collectorId + ", "
        + "nodeId=" + nodeId + ", "
        + "collectorName=" + collectorName + ", "
        + "renderedConfiguration=" + renderedConfiguration + ", "
        + "created=" + created
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CollectorUpload) {
      CollectorUpload that = (CollectorUpload) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.collectorId.equals(that.collectorId())
          && this.nodeId.equals(that.nodeId())
          && this.collectorName.equals(that.collectorName())
          && this.renderedConfiguration.equals(that.renderedConfiguration())
          && (this.created == null ? that.created() == null : this.created.equals(that.created()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= collectorId.hashCode();
    h$ *= 1000003;
    h$ ^= nodeId.hashCode();
    h$ *= 1000003;
    h$ ^= collectorName.hashCode();
    h$ *= 1000003;
    h$ ^= renderedConfiguration.hashCode();
    h$ *= 1000003;
    h$ ^= (created == null) ? 0 : created.hashCode();
    return h$;
  }

  @Override
  public CollectorUpload.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends CollectorUpload.Builder {
    private String id;
    private String collectorId;
    private String nodeId;
    private String collectorName;
    private String renderedConfiguration;
    private DateTime created;
    Builder() {
    }
    private Builder(CollectorUpload source) {
      this.id = source.id();
      this.collectorId = source.collectorId();
      this.nodeId = source.nodeId();
      this.collectorName = source.collectorName();
      this.renderedConfiguration = source.renderedConfiguration();
      this.created = source.created();
    }
    @Override
    public CollectorUpload.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public CollectorUpload.Builder collectorId(String collectorId) {
      if (collectorId == null) {
        throw new NullPointerException("Null collectorId");
      }
      this.collectorId = collectorId;
      return this;
    }
    @Override
    public CollectorUpload.Builder nodeId(String nodeId) {
      if (nodeId == null) {
        throw new NullPointerException("Null nodeId");
      }
      this.nodeId = nodeId;
      return this;
    }
    @Override
    public CollectorUpload.Builder collectorName(String collectorName) {
      if (collectorName == null) {
        throw new NullPointerException("Null collectorName");
      }
      this.collectorName = collectorName;
      return this;
    }
    @Override
    public CollectorUpload.Builder renderedConfiguration(String renderedConfiguration) {
      if (renderedConfiguration == null) {
        throw new NullPointerException("Null renderedConfiguration");
      }
      this.renderedConfiguration = renderedConfiguration;
      return this;
    }
    @Override
    public CollectorUpload.Builder created(DateTime created) {
      this.created = created;
      return this;
    }
    @Override
    public CollectorUpload build() {
      String missing = "";
      if (this.collectorId == null) {
        missing += " collectorId";
      }
      if (this.nodeId == null) {
        missing += " nodeId";
      }
      if (this.collectorName == null) {
        missing += " collectorName";
      }
      if (this.renderedConfiguration == null) {
        missing += " renderedConfiguration";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CollectorUpload(
          this.id,
          this.collectorId,
          this.nodeId,
          this.collectorName,
          this.renderedConfiguration,
          this.created);
    }
  }

}
