package org.graylog.plugins.sidecar.rest.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_NodeDetails extends NodeDetails {

  private final @NotNull @Size(min = 1) String operatingSystem;

  private final String ip;

  private final NodeMetrics metrics;

  private final List<NodeLogFile> logFileList;

  private final CollectorStatusList statusList;

  AutoValue_NodeDetails(
      @NotNull @Size(min = 1) String operatingSystem,
      @Nullable String ip,
      @Nullable NodeMetrics metrics,
      @Nullable List<NodeLogFile> logFileList,
      @Nullable CollectorStatusList statusList) {
    if (operatingSystem == null) {
      throw new NullPointerException("Null operatingSystem");
    }
    this.operatingSystem = operatingSystem;
    this.ip = ip;
    this.metrics = metrics;
    this.logFileList = logFileList;
    this.statusList = statusList;
  }

  @JsonProperty("operating_system")
  @Override
  public @NotNull @Size(min = 1) String operatingSystem() {
    return operatingSystem;
  }

  @JsonProperty("ip")
  @Nullable
  @Override
  public String ip() {
    return ip;
  }

  @JsonProperty("metrics")
  @Nullable
  @Override
  public NodeMetrics metrics() {
    return metrics;
  }

  @JsonProperty("log_file_list")
  @Nullable
  @Override
  public List<NodeLogFile> logFileList() {
    return logFileList;
  }

  @JsonProperty("status")
  @Nullable
  @Override
  public CollectorStatusList statusList() {
    return statusList;
  }

  @Override
  public String toString() {
    return "NodeDetails{"
        + "operatingSystem=" + operatingSystem + ", "
        + "ip=" + ip + ", "
        + "metrics=" + metrics + ", "
        + "logFileList=" + logFileList + ", "
        + "statusList=" + statusList
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NodeDetails) {
      NodeDetails that = (NodeDetails) o;
      return this.operatingSystem.equals(that.operatingSystem())
          && (this.ip == null ? that.ip() == null : this.ip.equals(that.ip()))
          && (this.metrics == null ? that.metrics() == null : this.metrics.equals(that.metrics()))
          && (this.logFileList == null ? that.logFileList() == null : this.logFileList.equals(that.logFileList()))
          && (this.statusList == null ? that.statusList() == null : this.statusList.equals(that.statusList()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= operatingSystem.hashCode();
    h$ *= 1000003;
    h$ ^= (ip == null) ? 0 : ip.hashCode();
    h$ *= 1000003;
    h$ ^= (metrics == null) ? 0 : metrics.hashCode();
    h$ *= 1000003;
    h$ ^= (logFileList == null) ? 0 : logFileList.hashCode();
    h$ *= 1000003;
    h$ ^= (statusList == null) ? 0 : statusList.hashCode();
    return h$;
  }

}
