package org.graylog.plugins.sidecar.rest.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.sidecar.rest.requests.ConfigurationAssignment;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Sidecar extends Sidecar {

  private final String id;

  private final String nodeId;

  private final String nodeName;

  private final NodeDetails nodeDetails;

  private final List<ConfigurationAssignment> assignments;

  private final String sidecarVersion;

  private final DateTime lastSeen;

  private AutoValue_Sidecar(
      @Nullable String id,
      String nodeId,
      String nodeName,
      NodeDetails nodeDetails,
      @Nullable List<ConfigurationAssignment> assignments,
      String sidecarVersion,
      DateTime lastSeen) {
    this.id = id;
    this.nodeId = nodeId;
    this.nodeName = nodeName;
    this.nodeDetails = nodeDetails;
    this.assignments = assignments;
    this.sidecarVersion = sidecarVersion;
    this.lastSeen = lastSeen;
  }

  @JsonProperty
  @Id
  @ObjectId
  @Nullable
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public String nodeId() {
    return nodeId;
  }

  @JsonProperty
  @Override
  public String nodeName() {
    return nodeName;
  }

  @JsonProperty
  @Override
  public NodeDetails nodeDetails() {
    return nodeDetails;
  }

  @JsonProperty
  @Nullable
  @Override
  public List<ConfigurationAssignment> assignments() {
    return assignments;
  }

  @JsonProperty
  @Override
  public String sidecarVersion() {
    return sidecarVersion;
  }

  @JsonProperty
  @Override
  public DateTime lastSeen() {
    return lastSeen;
  }

  @Override
  public String toString() {
    return "Sidecar{"
        + "id=" + id + ", "
        + "nodeId=" + nodeId + ", "
        + "nodeName=" + nodeName + ", "
        + "nodeDetails=" + nodeDetails + ", "
        + "assignments=" + assignments + ", "
        + "sidecarVersion=" + sidecarVersion + ", "
        + "lastSeen=" + lastSeen
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Sidecar) {
      Sidecar that = (Sidecar) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.nodeId.equals(that.nodeId())
          && this.nodeName.equals(that.nodeName())
          && this.nodeDetails.equals(that.nodeDetails())
          && (this.assignments == null ? that.assignments() == null : this.assignments.equals(that.assignments()))
          && this.sidecarVersion.equals(that.sidecarVersion())
          && this.lastSeen.equals(that.lastSeen());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= nodeId.hashCode();
    h$ *= 1000003;
    h$ ^= nodeName.hashCode();
    h$ *= 1000003;
    h$ ^= nodeDetails.hashCode();
    h$ *= 1000003;
    h$ ^= (assignments == null) ? 0 : assignments.hashCode();
    h$ *= 1000003;
    h$ ^= sidecarVersion.hashCode();
    h$ *= 1000003;
    h$ ^= lastSeen.hashCode();
    return h$;
  }

  @Override
  public Sidecar.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Sidecar.Builder {
    private String id;
    private String nodeId;
    private String nodeName;
    private NodeDetails nodeDetails;
    private List<ConfigurationAssignment> assignments;
    private String sidecarVersion;
    private DateTime lastSeen;
    Builder() {
    }
    private Builder(Sidecar source) {
      this.id = source.id();
      this.nodeId = source.nodeId();
      this.nodeName = source.nodeName();
      this.nodeDetails = source.nodeDetails();
      this.assignments = source.assignments();
      this.sidecarVersion = source.sidecarVersion();
      this.lastSeen = source.lastSeen();
    }
    @Override
    public Sidecar.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public Sidecar.Builder nodeId(String nodeId) {
      if (nodeId == null) {
        throw new NullPointerException("Null nodeId");
      }
      this.nodeId = nodeId;
      return this;
    }
    @Override
    public Sidecar.Builder nodeName(String nodeName) {
      if (nodeName == null) {
        throw new NullPointerException("Null nodeName");
      }
      this.nodeName = nodeName;
      return this;
    }
    @Override
    public Sidecar.Builder nodeDetails(NodeDetails nodeDetails) {
      if (nodeDetails == null) {
        throw new NullPointerException("Null nodeDetails");
      }
      this.nodeDetails = nodeDetails;
      return this;
    }
    @Override
    public Sidecar.Builder assignments(List<ConfigurationAssignment> assignments) {
      this.assignments = assignments;
      return this;
    }
    @Override
    public Sidecar.Builder sidecarVersion(String sidecarVersion) {
      if (sidecarVersion == null) {
        throw new NullPointerException("Null sidecarVersion");
      }
      this.sidecarVersion = sidecarVersion;
      return this;
    }
    @Override
    public Sidecar.Builder lastSeen(DateTime lastSeen) {
      if (lastSeen == null) {
        throw new NullPointerException("Null lastSeen");
      }
      this.lastSeen = lastSeen;
      return this;
    }
    @Override
    public Sidecar build() {
      String missing = "";
      if (this.nodeId == null) {
        missing += " nodeId";
      }
      if (this.nodeName == null) {
        missing += " nodeName";
      }
      if (this.nodeDetails == null) {
        missing += " nodeDetails";
      }
      if (this.sidecarVersion == null) {
        missing += " sidecarVersion";
      }
      if (this.lastSeen == null) {
        missing += " lastSeen";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Sidecar(
          this.id,
          this.nodeId,
          this.nodeName,
          this.nodeDetails,
          this.assignments,
          this.sidecarVersion,
          this.lastSeen);
    }
  }

}
