package org.graylog.plugins.sidecar.rest.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.sidecar.rest.requests.ConfigurationAssignment;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SidecarSummary extends SidecarSummary {

  private final String nodeId;

  private final String nodeName;

  private final NodeDetails nodeDetails;

  private final List<ConfigurationAssignment> assignments;

  private final DateTime lastSeen;

  private final String sidecarVersion;

  private final List<String> collectors;

  private final boolean active;

  private AutoValue_SidecarSummary(
      String nodeId,
      String nodeName,
      NodeDetails nodeDetails,
      List<ConfigurationAssignment> assignments,
      DateTime lastSeen,
      String sidecarVersion,
      @Nullable List<String> collectors,
      boolean active) {
    this.nodeId = nodeId;
    this.nodeName = nodeName;
    this.nodeDetails = nodeDetails;
    this.assignments = assignments;
    this.lastSeen = lastSeen;
    this.sidecarVersion = sidecarVersion;
    this.collectors = collectors;
    this.active = active;
  }

  @JsonProperty("node_id")
  @Override
  public String nodeId() {
    return nodeId;
  }

  @JsonProperty("node_name")
  @Override
  public String nodeName() {
    return nodeName;
  }

  @JsonProperty("node_details")
  @Override
  public NodeDetails nodeDetails() {
    return nodeDetails;
  }

  @JsonProperty("assignments")
  @Override
  public List<ConfigurationAssignment> assignments() {
    return assignments;
  }

  @JsonProperty("last_seen")
  @Override
  public DateTime lastSeen() {
    return lastSeen;
  }

  @JsonProperty("sidecar_version")
  @Override
  public String sidecarVersion() {
    return sidecarVersion;
  }

  @Nullable
  @JsonProperty("collectors")
  @Override
  public List<String> collectors() {
    return collectors;
  }

  @JsonProperty
  @Override
  public boolean active() {
    return active;
  }

  @Override
  public String toString() {
    return "SidecarSummary{"
        + "nodeId=" + nodeId + ", "
        + "nodeName=" + nodeName + ", "
        + "nodeDetails=" + nodeDetails + ", "
        + "assignments=" + assignments + ", "
        + "lastSeen=" + lastSeen + ", "
        + "sidecarVersion=" + sidecarVersion + ", "
        + "collectors=" + collectors + ", "
        + "active=" + active
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SidecarSummary) {
      SidecarSummary that = (SidecarSummary) o;
      return this.nodeId.equals(that.nodeId())
          && this.nodeName.equals(that.nodeName())
          && this.nodeDetails.equals(that.nodeDetails())
          && this.assignments.equals(that.assignments())
          && this.lastSeen.equals(that.lastSeen())
          && this.sidecarVersion.equals(that.sidecarVersion())
          && (this.collectors == null ? that.collectors() == null : this.collectors.equals(that.collectors()))
          && this.active == that.active();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= nodeId.hashCode();
    h$ *= 1000003;
    h$ ^= nodeName.hashCode();
    h$ *= 1000003;
    h$ ^= nodeDetails.hashCode();
    h$ *= 1000003;
    h$ ^= assignments.hashCode();
    h$ *= 1000003;
    h$ ^= lastSeen.hashCode();
    h$ *= 1000003;
    h$ ^= sidecarVersion.hashCode();
    h$ *= 1000003;
    h$ ^= (collectors == null) ? 0 : collectors.hashCode();
    h$ *= 1000003;
    h$ ^= active ? 1231 : 1237;
    return h$;
  }

  @Override
  public SidecarSummary.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends SidecarSummary.Builder {
    private String nodeId;
    private String nodeName;
    private NodeDetails nodeDetails;
    private List<ConfigurationAssignment> assignments;
    private DateTime lastSeen;
    private String sidecarVersion;
    private List<String> collectors;
    private Boolean active;
    Builder() {
    }
    private Builder(SidecarSummary source) {
      this.nodeId = source.nodeId();
      this.nodeName = source.nodeName();
      this.nodeDetails = source.nodeDetails();
      this.assignments = source.assignments();
      this.lastSeen = source.lastSeen();
      this.sidecarVersion = source.sidecarVersion();
      this.collectors = source.collectors();
      this.active = source.active();
    }
    @Override
    public SidecarSummary.Builder nodeId(String nodeId) {
      if (nodeId == null) {
        throw new NullPointerException("Null nodeId");
      }
      this.nodeId = nodeId;
      return this;
    }
    @Override
    public SidecarSummary.Builder nodeName(String nodeName) {
      if (nodeName == null) {
        throw new NullPointerException("Null nodeName");
      }
      this.nodeName = nodeName;
      return this;
    }
    @Override
    public SidecarSummary.Builder nodeDetails(NodeDetails nodeDetails) {
      if (nodeDetails == null) {
        throw new NullPointerException("Null nodeDetails");
      }
      this.nodeDetails = nodeDetails;
      return this;
    }
    @Override
    public SidecarSummary.Builder assignments(List<ConfigurationAssignment> assignments) {
      if (assignments == null) {
        throw new NullPointerException("Null assignments");
      }
      this.assignments = assignments;
      return this;
    }
    @Override
    public SidecarSummary.Builder lastSeen(DateTime lastSeen) {
      if (lastSeen == null) {
        throw new NullPointerException("Null lastSeen");
      }
      this.lastSeen = lastSeen;
      return this;
    }
    @Override
    public SidecarSummary.Builder sidecarVersion(String sidecarVersion) {
      if (sidecarVersion == null) {
        throw new NullPointerException("Null sidecarVersion");
      }
      this.sidecarVersion = sidecarVersion;
      return this;
    }
    @Override
    public SidecarSummary.Builder collectors(List<String> collectors) {
      this.collectors = collectors;
      return this;
    }
    @Override
    public SidecarSummary.Builder active(boolean active) {
      this.active = active;
      return this;
    }
    @Override
    public SidecarSummary build() {
      String missing = "";
      if (this.nodeId == null) {
        missing += " nodeId";
      }
      if (this.nodeName == null) {
        missing += " nodeName";
      }
      if (this.nodeDetails == null) {
        missing += " nodeDetails";
      }
      if (this.assignments == null) {
        missing += " assignments";
      }
      if (this.lastSeen == null) {
        missing += " lastSeen";
      }
      if (this.sidecarVersion == null) {
        missing += " sidecarVersion";
      }
      if (this.active == null) {
        missing += " active";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SidecarSummary(
          this.nodeId,
          this.nodeName,
          this.nodeDetails,
          this.assignments,
          this.lastSeen,
          this.sidecarVersion,
          this.collectors,
          this.active);
    }
  }

}
