package org.graylog.plugins.sidecar.rest.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.sidecar.rest.models.CollectorAction;
import org.graylog.plugins.sidecar.rest.models.SidecarRegistrationConfiguration;
import org.graylog.plugins.sidecar.rest.requests.ConfigurationAssignment;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RegistrationResponse extends RegistrationResponse {

  private final SidecarRegistrationConfiguration configuration;

  private final boolean configurationOverride;

  private final List<CollectorAction> actions;

  private final List<ConfigurationAssignment> assignments;

  AutoValue_RegistrationResponse(
      SidecarRegistrationConfiguration configuration,
      boolean configurationOverride,
      @Nullable List<CollectorAction> actions,
      @Nullable List<ConfigurationAssignment> assignments) {
    if (configuration == null) {
      throw new NullPointerException("Null configuration");
    }
    this.configuration = configuration;
    this.configurationOverride = configurationOverride;
    this.actions = actions;
    this.assignments = assignments;
  }

  @JsonProperty("configuration")
  @Override
  public SidecarRegistrationConfiguration configuration() {
    return configuration;
  }

  @JsonProperty("configuration_override")
  @Override
  public boolean configurationOverride() {
    return configurationOverride;
  }

  @JsonProperty("actions")
  @Nullable
  @Override
  public List<CollectorAction> actions() {
    return actions;
  }

  @JsonProperty("assignments")
  @Nullable
  @Override
  public List<ConfigurationAssignment> assignments() {
    return assignments;
  }

  @Override
  public String toString() {
    return "RegistrationResponse{"
        + "configuration=" + configuration + ", "
        + "configurationOverride=" + configurationOverride + ", "
        + "actions=" + actions + ", "
        + "assignments=" + assignments
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RegistrationResponse) {
      RegistrationResponse that = (RegistrationResponse) o;
      return this.configuration.equals(that.configuration())
          && this.configurationOverride == that.configurationOverride()
          && (this.actions == null ? that.actions() == null : this.actions.equals(that.actions()))
          && (this.assignments == null ? that.assignments() == null : this.assignments.equals(that.assignments()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= configuration.hashCode();
    h$ *= 1000003;
    h$ ^= configurationOverride ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (actions == null) ? 0 : actions.hashCode();
    h$ *= 1000003;
    h$ ^= (assignments == null) ? 0 : assignments.hashCode();
    return h$;
  }

}
