package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Pivot extends Pivot {

  private final String id;

  private final Optional<TimeRange> timerange;

  private final Optional<ElasticsearchQueryString> query;

  private final Set<String> streams;

  private final Optional<String> name;

  private final List<BucketSpec> rowGroups;

  private final List<BucketSpec> columnGroups;

  private final List<SeriesSpec> series;

  private final List<SortSpec> sort;

  private final boolean rollup;

  private AutoValue_Pivot(
      String id,
      Optional<TimeRange> timerange,
      Optional<ElasticsearchQueryString> query,
      Set<String> streams,
      Optional<String> name,
      List<BucketSpec> rowGroups,
      List<BucketSpec> columnGroups,
      List<SeriesSpec> series,
      List<SortSpec> sort,
      boolean rollup) {
    this.id = id;
    this.timerange = timerange;
    this.query = query;
    this.streams = streams;
    this.name = name;
    this.rowGroups = rowGroups;
    this.columnGroups = columnGroups;
    this.series = series;
    this.sort = sort;
    this.rollup = rollup;
  }

  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public Optional<TimeRange> timerange() {
    return timerange;
  }

  @JsonProperty
  @Override
  public Optional<ElasticsearchQueryString> query() {
    return query;
  }

  @JsonProperty
  @Override
  public Set<String> streams() {
    return streams;
  }

  @JsonProperty
  @Override
  public Optional<String> name() {
    return name;
  }

  @JsonProperty("row_groups")
  @Override
  List<BucketSpec> rowGroups() {
    return rowGroups;
  }

  @JsonProperty("column_groups")
  @Override
  List<BucketSpec> columnGroups() {
    return columnGroups;
  }

  @JsonProperty
  @Override
  List<SeriesSpec> series() {
    return series;
  }

  @JsonProperty
  @Override
  List<SortSpec> sort() {
    return sort;
  }

  @JsonProperty
  @Override
  boolean rollup() {
    return rollup;
  }

  @Override
  public String toString() {
    return "Pivot{"
        + "id=" + id + ", "
        + "timerange=" + timerange + ", "
        + "query=" + query + ", "
        + "streams=" + streams + ", "
        + "name=" + name + ", "
        + "rowGroups=" + rowGroups + ", "
        + "columnGroups=" + columnGroups + ", "
        + "series=" + series + ", "
        + "sort=" + sort + ", "
        + "rollup=" + rollup
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Pivot) {
      Pivot that = (Pivot) o;
      return this.id.equals(that.id())
          && this.timerange.equals(that.timerange())
          && this.query.equals(that.query())
          && this.streams.equals(that.streams())
          && this.name.equals(that.name())
          && this.rowGroups.equals(that.rowGroups())
          && this.columnGroups.equals(that.columnGroups())
          && this.series.equals(that.series())
          && this.sort.equals(that.sort())
          && this.rollup == that.rollup();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= rowGroups.hashCode();
    h$ *= 1000003;
    h$ ^= columnGroups.hashCode();
    h$ *= 1000003;
    h$ ^= series.hashCode();
    h$ *= 1000003;
    h$ ^= sort.hashCode();
    h$ *= 1000003;
    h$ ^= rollup ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends Pivot.Builder {
    private String id;
    private Optional<TimeRange> timerange = Optional.empty();
    private Optional<ElasticsearchQueryString> query = Optional.empty();
    private Set<String> streams;
    private Optional<String> name = Optional.empty();
    private List<BucketSpec> rowGroups;
    private List<BucketSpec> columnGroups;
    private List<SeriesSpec> series;
    private List<SortSpec> sort;
    private Boolean rollup;
    Builder() {
    }
    @Override
    Pivot.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    Pivot.Builder timerange(@Nullable TimeRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    Pivot.Builder query(@Nullable ElasticsearchQueryString query) {
      this.query = Optional.ofNullable(query);
      return this;
    }
    @Override
    Pivot.Builder streams(Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    Pivot.Builder name(@Nullable String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }
    @Override
    Pivot.Builder rowGroups(List<BucketSpec> rowGroups) {
      if (rowGroups == null) {
        throw new NullPointerException("Null rowGroups");
      }
      this.rowGroups = rowGroups;
      return this;
    }
    @Override
    Pivot.Builder columnGroups(List<BucketSpec> columnGroups) {
      if (columnGroups == null) {
        throw new NullPointerException("Null columnGroups");
      }
      this.columnGroups = columnGroups;
      return this;
    }
    @Override
    Pivot.Builder series(List<SeriesSpec> series) {
      if (series == null) {
        throw new NullPointerException("Null series");
      }
      this.series = series;
      return this;
    }
    @Override
    Pivot.Builder sort(List<SortSpec> sort) {
      if (sort == null) {
        throw new NullPointerException("Null sort");
      }
      this.sort = sort;
      return this;
    }
    @Override
    Pivot.Builder rollup(boolean rollup) {
      this.rollup = rollup;
      return this;
    }
    @Override
    Pivot build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.rowGroups == null) {
        missing += " rowGroups";
      }
      if (this.columnGroups == null) {
        missing += " columnGroups";
      }
      if (this.series == null) {
        missing += " series";
      }
      if (this.sort == null) {
        missing += " sort";
      }
      if (this.rollup == null) {
        missing += " rollup";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Pivot(
          this.id,
          this.timerange,
          this.query,
          this.streams,
          this.name,
          this.rowGroups,
          this.columnGroups,
          this.series,
          this.sort,
          this.rollup);
    }
  }

}
