package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AggregationConfig extends AggregationConfig {

  private final List<Pivot> rowPivots;

  private final List<Pivot> columnPivots;

  private final List<Series> series;

  private final List<SortConfig> sort;

  private final String visualization;

  private final Optional<VisualizationConfig> visualizationConfig;

  private final boolean rollup;

  private AutoValue_AggregationConfig(
      List<Pivot> rowPivots,
      List<Pivot> columnPivots,
      List<Series> series,
      List<SortConfig> sort,
      String visualization,
      Optional<VisualizationConfig> visualizationConfig,
      boolean rollup) {
    this.rowPivots = rowPivots;
    this.columnPivots = columnPivots;
    this.series = series;
    this.sort = sort;
    this.visualization = visualization;
    this.visualizationConfig = visualizationConfig;
    this.rollup = rollup;
  }

  @JsonProperty("row_pivots")
  @Override
  public List<Pivot> rowPivots() {
    return rowPivots;
  }

  @JsonProperty("column_pivots")
  @Override
  public List<Pivot> columnPivots() {
    return columnPivots;
  }

  @JsonProperty("series")
  @Override
  public List<Series> series() {
    return series;
  }

  @JsonProperty("sort")
  @Override
  public List<SortConfig> sort() {
    return sort;
  }

  @JsonProperty("visualization")
  @Override
  public String visualization() {
    return visualization;
  }

  @JsonProperty("visualization_config")
  @Override
  public Optional<VisualizationConfig> visualizationConfig() {
    return visualizationConfig;
  }

  @JsonProperty("rollup")
  @Override
  public boolean rollup() {
    return rollup;
  }

  @Override
  public String toString() {
    return "AggregationConfig{"
        + "rowPivots=" + rowPivots + ", "
        + "columnPivots=" + columnPivots + ", "
        + "series=" + series + ", "
        + "sort=" + sort + ", "
        + "visualization=" + visualization + ", "
        + "visualizationConfig=" + visualizationConfig + ", "
        + "rollup=" + rollup
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AggregationConfig) {
      AggregationConfig that = (AggregationConfig) o;
      return this.rowPivots.equals(that.rowPivots())
          && this.columnPivots.equals(that.columnPivots())
          && this.series.equals(that.series())
          && this.sort.equals(that.sort())
          && this.visualization.equals(that.visualization())
          && this.visualizationConfig.equals(that.visualizationConfig())
          && this.rollup == that.rollup();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= rowPivots.hashCode();
    h$ *= 1000003;
    h$ ^= columnPivots.hashCode();
    h$ *= 1000003;
    h$ ^= series.hashCode();
    h$ *= 1000003;
    h$ ^= sort.hashCode();
    h$ *= 1000003;
    h$ ^= visualization.hashCode();
    h$ *= 1000003;
    h$ ^= visualizationConfig.hashCode();
    h$ *= 1000003;
    h$ ^= rollup ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends AggregationConfig.Builder {
    private List<Pivot> rowPivots;
    private List<Pivot> columnPivots;
    private List<Series> series;
    private List<SortConfig> sort;
    private String visualization;
    private Optional<VisualizationConfig> visualizationConfig = Optional.empty();
    private Boolean rollup;
    Builder() {
    }
    @Override
    public AggregationConfig.Builder rowPivots(List<Pivot> rowPivots) {
      if (rowPivots == null) {
        throw new NullPointerException("Null rowPivots");
      }
      this.rowPivots = rowPivots;
      return this;
    }
    @Override
    public AggregationConfig.Builder columnPivots(List<Pivot> columnPivots) {
      if (columnPivots == null) {
        throw new NullPointerException("Null columnPivots");
      }
      this.columnPivots = columnPivots;
      return this;
    }
    @Override
    public AggregationConfig.Builder series(List<Series> series) {
      if (series == null) {
        throw new NullPointerException("Null series");
      }
      this.series = series;
      return this;
    }
    @Override
    public AggregationConfig.Builder sort(List<SortConfig> sort) {
      if (sort == null) {
        throw new NullPointerException("Null sort");
      }
      this.sort = sort;
      return this;
    }
    @Override
    public AggregationConfig.Builder visualization(String visualization) {
      if (visualization == null) {
        throw new NullPointerException("Null visualization");
      }
      this.visualization = visualization;
      return this;
    }
    @Override
    public AggregationConfig.Builder visualizationConfig(VisualizationConfig visualizationConfig) {
      this.visualizationConfig = Optional.of(visualizationConfig);
      return this;
    }
    @Override
    public AggregationConfig.Builder rollup(boolean rollup) {
      this.rollup = rollup;
      return this;
    }
    @Override
    public AggregationConfig build() {
      String missing = "";
      if (this.rowPivots == null) {
        missing += " rowPivots";
      }
      if (this.columnPivots == null) {
        missing += " columnPivots";
      }
      if (this.series == null) {
        missing += " series";
      }
      if (this.sort == null) {
        missing += " sort";
      }
      if (this.visualization == null) {
        missing += " visualization";
      }
      if (this.rollup == null) {
        missing += " rollup";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AggregationConfig(
          this.rowPivots,
          this.columnPivots,
          this.series,
          this.sort,
          this.visualization,
          this.visualizationConfig,
          this.rollup);
    }
  }

}
