package org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.ElasticsearchQueryString;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Query extends Query {

  private final String id;

  private final TimeRange timerange;

  private final Optional<StreamFilter> filter;

  private final ElasticsearchQueryString query;

  private final Set<SearchType> searchTypes;

  private AutoValue_Query(
      String id,
      TimeRange timerange,
      Optional<StreamFilter> filter,
      ElasticsearchQueryString query,
      Set<SearchType> searchTypes) {
    this.id = id;
    this.timerange = timerange;
    this.filter = filter;
    this.query = query;
    this.searchTypes = searchTypes;
  }

  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public TimeRange timerange() {
    return timerange;
  }

  @JsonProperty
  @Override
  public Optional<StreamFilter> filter() {
    return filter;
  }

  @Nonnull
  @JsonProperty
  @Override
  public ElasticsearchQueryString query() {
    return query;
  }

  @Nonnull
  @JsonProperty("search_types")
  @Override
  public Set<SearchType> searchTypes() {
    return searchTypes;
  }

  @Override
  public String toString() {
    return "Query{"
        + "id=" + id + ", "
        + "timerange=" + timerange + ", "
        + "filter=" + filter + ", "
        + "query=" + query + ", "
        + "searchTypes=" + searchTypes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Query) {
      Query that = (Query) o;
      return this.id.equals(that.id())
          && this.timerange.equals(that.timerange())
          && this.filter.equals(that.filter())
          && this.query.equals(that.query())
          && this.searchTypes.equals(that.searchTypes());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= filter.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= searchTypes.hashCode();
    return h$;
  }

  static final class Builder extends Query.Builder {
    private String id;
    private TimeRange timerange;
    private Optional<StreamFilter> filter = Optional.empty();
    private ElasticsearchQueryString query;
    private Set<SearchType> searchTypes;
    Builder() {
    }
    @Override
    public Query.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public Query.Builder timerange(TimeRange timerange) {
      if (timerange == null) {
        throw new NullPointerException("Null timerange");
      }
      this.timerange = timerange;
      return this;
    }
    @Override
    public Query.Builder filter(StreamFilter filter) {
      this.filter = Optional.of(filter);
      return this;
    }
    @Override
    Query.Builder query(ElasticsearchQueryString query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public Query.Builder searchTypes(Set<SearchType> searchTypes) {
      if (searchTypes == null) {
        throw new NullPointerException("Null searchTypes");
      }
      this.searchTypes = searchTypes;
      return this;
    }
    @Override
    public Query build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.timerange == null) {
        missing += " timerange";
      }
      if (this.query == null) {
        missing += " query";
      }
      if (this.searchTypes == null) {
        missing += " searchTypes";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Query(
          this.id,
          this.timerange,
          this.filter,
          this.query,
          this.searchTypes);
    }
  }

}
