package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Query extends Query {

  private final String id;

  private final TimeRange timerange;

  private final Filter filter;

  private final BackendQuery query;

  private final Optional<GlobalOverride> globalOverride;

  private final ImmutableSet<SearchType> searchTypes;

  private AutoValue_Query(
      String id,
      TimeRange timerange,
      @Nullable Filter filter,
      BackendQuery query,
      Optional<GlobalOverride> globalOverride,
      ImmutableSet<SearchType> searchTypes) {
    this.id = id;
    this.timerange = timerange;
    this.filter = filter;
    this.query = query;
    this.globalOverride = globalOverride;
    this.searchTypes = searchTypes;
  }

  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public TimeRange timerange() {
    return timerange;
  }

  @Nullable
  @JsonProperty
  @Override
  public Filter filter() {
    return filter;
  }

  @Nonnull
  @JsonProperty
  @Override
  public BackendQuery query() {
    return query;
  }

  @JsonIgnore
  @Override
  public Optional<GlobalOverride> globalOverride() {
    return globalOverride;
  }

  @Nonnull
  @JsonProperty("search_types")
  @Override
  public ImmutableSet<SearchType> searchTypes() {
    return searchTypes;
  }

  @Override
  public String toString() {
    return "Query{"
        + "id=" + id + ", "
        + "timerange=" + timerange + ", "
        + "filter=" + filter + ", "
        + "query=" + query + ", "
        + "globalOverride=" + globalOverride + ", "
        + "searchTypes=" + searchTypes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Query) {
      Query that = (Query) o;
      return this.id.equals(that.id())
          && this.timerange.equals(that.timerange())
          && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter()))
          && this.query.equals(that.query())
          && this.globalOverride.equals(that.globalOverride())
          && this.searchTypes.equals(that.searchTypes());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= (filter == null) ? 0 : filter.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= globalOverride.hashCode();
    h$ *= 1000003;
    h$ ^= searchTypes.hashCode();
    return h$;
  }

  @Override
  public Query.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Query.Builder {
    private String id;
    private TimeRange timerange;
    private Filter filter;
    private BackendQuery query;
    private Optional<GlobalOverride> globalOverride = Optional.empty();
    private ImmutableSet<SearchType> searchTypes;
    Builder() {
    }
    private Builder(Query source) {
      this.id = source.id();
      this.timerange = source.timerange();
      this.filter = source.filter();
      this.query = source.query();
      this.globalOverride = source.globalOverride();
      this.searchTypes = source.searchTypes();
    }
    @Override
    public Query.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public Query.Builder timerange(TimeRange timerange) {
      if (timerange == null) {
        throw new NullPointerException("Null timerange");
      }
      this.timerange = timerange;
      return this;
    }
    @Override
    public Query.Builder filter(Filter filter) {
      this.filter = filter;
      return this;
    }
    @Override
    public Query.Builder query(BackendQuery query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public Query.Builder globalOverride(@Nullable GlobalOverride globalOverride) {
      this.globalOverride = Optional.ofNullable(globalOverride);
      return this;
    }
    @Override
    public Query.Builder searchTypes(@Nullable Set<SearchType> searchTypes) {
      this.searchTypes = ImmutableSet.copyOf(searchTypes);
      return this;
    }
    @Override
    Query autoBuild() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.timerange == null) {
        missing += " timerange";
      }
      if (this.query == null) {
        missing += " query";
      }
      if (this.searchTypes == null) {
        missing += " searchTypes";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Query(
          this.id,
          this.timerange,
          this.filter,
          this.query,
          this.globalOverride,
          this.searchTypes);
    }
  }

}
