package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QueryMetadata extends QueryMetadata {

  private final ImmutableSet<String> usedParameterNames;

  private final ImmutableSet<String> referencedQueries;

  private AutoValue_QueryMetadata(
      ImmutableSet<String> usedParameterNames,
      ImmutableSet<String> referencedQueries) {
    this.usedParameterNames = usedParameterNames;
    this.referencedQueries = referencedQueries;
  }

  @JsonProperty("used_parameters_names")
  @Override
  public ImmutableSet<String> usedParameterNames() {
    return usedParameterNames;
  }

  @JsonProperty("referenced_queries")
  @Override
  public ImmutableSet<String> referencedQueries() {
    return referencedQueries;
  }

  @Override
  public String toString() {
    return "QueryMetadata{"
        + "usedParameterNames=" + usedParameterNames + ", "
        + "referencedQueries=" + referencedQueries
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryMetadata) {
      QueryMetadata that = (QueryMetadata) o;
      return this.usedParameterNames.equals(that.usedParameterNames())
          && this.referencedQueries.equals(that.referencedQueries());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= usedParameterNames.hashCode();
    h$ *= 1000003;
    h$ ^= referencedQueries.hashCode();
    return h$;
  }

  @Override
  public QueryMetadata.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends QueryMetadata.Builder {
    private ImmutableSet<String> usedParameterNames;
    private ImmutableSet<String> referencedQueries;
    Builder() {
    }
    private Builder(QueryMetadata source) {
      this.usedParameterNames = source.usedParameterNames();
      this.referencedQueries = source.referencedQueries();
    }
    @Override
    public QueryMetadata.Builder usedParameterNames(Set<String> usedParameterNames) {
      this.usedParameterNames = ImmutableSet.copyOf(usedParameterNames);
      return this;
    }
    @Override
    public QueryMetadata.Builder referencedQueries(Set<String> referencedQueries) {
      this.referencedQueries = ImmutableSet.copyOf(referencedQueries);
      return this;
    }
    @Override
    public QueryMetadata build() {
      String missing = "";
      if (this.usedParameterNames == null) {
        missing += " usedParameterNames";
      }
      if (this.referencedQueries == null) {
        missing += " referencedQueries";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QueryMetadata(
          this.usedParameterNames,
          this.referencedQueries);
    }
  }

}
