package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.engine.QueryExecutionStats;
import org.graylog.plugins.views.search.errors.SearchError;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QueryResult extends QueryResult {

  private final Query query;

  private final QueryExecutionStats executionStats;

  private final Map<String, SearchType.Result> searchTypes;

  private final Set<SearchError> errors;

  private final QueryResult.State state;

  private AutoValue_QueryResult(
      Query query,
      QueryExecutionStats executionStats,
      Map<String, SearchType.Result> searchTypes,
      @Nullable Set<SearchError> errors,
      QueryResult.State state) {
    this.query = query;
    this.executionStats = executionStats;
    this.searchTypes = searchTypes;
    this.errors = errors;
    this.state = state;
  }

  @JsonProperty
  @Override
  public Query query() {
    return query;
  }

  @JsonProperty("execution_stats")
  @Override
  public QueryExecutionStats executionStats() {
    return executionStats;
  }

  @JsonProperty("search_types")
  @Override
  public Map<String, SearchType.Result> searchTypes() {
    return searchTypes;
  }

  @JsonProperty("errors")
  @Nullable
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Set<SearchError> errors() {
    return errors;
  }

  @JsonProperty("state")
  @Override
  public QueryResult.State state() {
    return state;
  }

  @Override
  public String toString() {
    return "QueryResult{"
        + "query=" + query + ", "
        + "executionStats=" + executionStats + ", "
        + "searchTypes=" + searchTypes + ", "
        + "errors=" + errors + ", "
        + "state=" + state
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryResult) {
      QueryResult that = (QueryResult) o;
      return this.query.equals(that.query())
          && this.executionStats.equals(that.executionStats())
          && this.searchTypes.equals(that.searchTypes())
          && (this.errors == null ? that.errors() == null : this.errors.equals(that.errors()))
          && this.state.equals(that.state());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= executionStats.hashCode();
    h$ *= 1000003;
    h$ ^= searchTypes.hashCode();
    h$ *= 1000003;
    h$ ^= (errors == null) ? 0 : errors.hashCode();
    h$ *= 1000003;
    h$ ^= state.hashCode();
    return h$;
  }

  @Override
  public QueryResult.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends QueryResult.Builder {
    private Query query;
    private QueryExecutionStats executionStats;
    private Map<String, SearchType.Result> searchTypes;
    private Set<SearchError> errors;
    private QueryResult.State state;
    Builder() {
    }
    private Builder(QueryResult source) {
      this.query = source.query();
      this.executionStats = source.executionStats();
      this.searchTypes = source.searchTypes();
      this.errors = source.errors();
      this.state = source.state();
    }
    @Override
    public QueryResult.Builder query(Query query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public QueryResult.Builder executionStats(QueryExecutionStats executionStats) {
      if (executionStats == null) {
        throw new NullPointerException("Null executionStats");
      }
      this.executionStats = executionStats;
      return this;
    }
    @Override
    public QueryResult.Builder searchTypes(Map<String, SearchType.Result> searchTypes) {
      if (searchTypes == null) {
        throw new NullPointerException("Null searchTypes");
      }
      this.searchTypes = searchTypes;
      return this;
    }
    @Override
    public QueryResult.Builder errors(@Nullable Set<SearchError> errors) {
      this.errors = errors;
      return this;
    }
    @Override
    public QueryResult.Builder state(QueryResult.State state) {
      if (state == null) {
        throw new NullPointerException("Null state");
      }
      this.state = state;
      return this;
    }
    @Override
    public QueryResult build() {
      String missing = "";
      if (this.query == null) {
        missing += " query";
      }
      if (this.executionStats == null) {
        missing += " executionStats";
      }
      if (this.searchTypes == null) {
        missing += " searchTypes";
      }
      if (this.state == null) {
        missing += " state";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QueryResult(
          this.query,
          this.executionStats,
          this.searchTypes,
          this.errors,
          this.state);
    }
  }

}
