package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Search extends Search {

  private final String id;

  private final ImmutableSet<Query> queries;

  private final ImmutableSet<Parameter> parameters;

  private final Map<String, PluginMetadataSummary> requires;

  private final Optional<String> owner;

  private final DateTime createdAt;

  private AutoValue_Search(
      @Nullable String id,
      ImmutableSet<Query> queries,
      ImmutableSet<Parameter> parameters,
      Map<String, PluginMetadataSummary> requires,
      Optional<String> owner,
      DateTime createdAt) {
    this.id = id;
    this.queries = queries;
    this.parameters = parameters;
    this.requires = requires;
    this.owner = owner;
    this.createdAt = createdAt;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public ImmutableSet<Query> queries() {
    return queries;
  }

  @JsonProperty
  @Override
  public ImmutableSet<Parameter> parameters() {
    return parameters;
  }

  @JsonProperty("requires")
  @Override
  public Map<String, PluginMetadataSummary> requires() {
    return requires;
  }

  @JsonProperty("owner")
  @Override
  public Optional<String> owner() {
    return owner;
  }

  @JsonProperty("created_at")
  @Override
  public DateTime createdAt() {
    return createdAt;
  }

  @Override
  public String toString() {
    return "Search{"
        + "id=" + id + ", "
        + "queries=" + queries + ", "
        + "parameters=" + parameters + ", "
        + "requires=" + requires + ", "
        + "owner=" + owner + ", "
        + "createdAt=" + createdAt
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Search) {
      Search that = (Search) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.queries.equals(that.queries())
          && this.parameters.equals(that.parameters())
          && this.requires.equals(that.requires())
          && this.owner.equals(that.owner())
          && this.createdAt.equals(that.createdAt());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= queries.hashCode();
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    h$ *= 1000003;
    h$ ^= requires.hashCode();
    h$ *= 1000003;
    h$ ^= owner.hashCode();
    h$ *= 1000003;
    h$ ^= createdAt.hashCode();
    return h$;
  }

  @Override
  public Search.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Search.Builder {
    private String id;
    private ImmutableSet<Query> queries;
    private ImmutableSet<Parameter> parameters;
    private Map<String, PluginMetadataSummary> requires;
    private Optional<String> owner = Optional.empty();
    private DateTime createdAt;
    Builder() {
    }
    private Builder(Search source) {
      this.id = source.id();
      this.queries = source.queries();
      this.parameters = source.parameters();
      this.requires = source.requires();
      this.owner = source.owner();
      this.createdAt = source.createdAt();
    }
    @Override
    public Search.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public Search.Builder queries(ImmutableSet<Query> queries) {
      if (queries == null) {
        throw new NullPointerException("Null queries");
      }
      this.queries = queries;
      return this;
    }
    @Override
    public Search.Builder parameters(ImmutableSet<Parameter> parameters) {
      if (parameters == null) {
        throw new NullPointerException("Null parameters");
      }
      this.parameters = parameters;
      return this;
    }
    @Override
    public Search.Builder requires(Map<String, PluginMetadataSummary> requires) {
      if (requires == null) {
        throw new NullPointerException("Null requires");
      }
      this.requires = requires;
      return this;
    }
    @Override
    public Search.Builder owner(@Nullable String owner) {
      this.owner = Optional.ofNullable(owner);
      return this;
    }
    @Override
    public Search.Builder createdAt(DateTime createdAt) {
      if (createdAt == null) {
        throw new NullPointerException("Null createdAt");
      }
      this.createdAt = createdAt;
      return this;
    }
    @Override
    Search autoBuild() {
      String missing = "";
      if (this.queries == null) {
        missing += " queries";
      }
      if (this.parameters == null) {
        missing += " parameters";
      }
      if (this.requires == null) {
        missing += " requires";
      }
      if (this.createdAt == null) {
        missing += " createdAt";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Search(
          this.id,
          this.queries,
          this.parameters,
          this.requires,
          this.owner,
          this.createdAt);
    }
  }

}
