package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SearchSummary extends SearchSummary {

  private final String id;

  private final Optional<String> owner;

  private final DateTime createdAt;

  private AutoValue_SearchSummary(
      @Nullable String id,
      Optional<String> owner,
      DateTime createdAt) {
    this.id = id;
    this.owner = owner;
    this.createdAt = createdAt;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("owner")
  @Override
  public Optional<String> owner() {
    return owner;
  }

  @JsonProperty("created_at")
  @Override
  public DateTime createdAt() {
    return createdAt;
  }

  @Override
  public String toString() {
    return "SearchSummary{"
        + "id=" + id + ", "
        + "owner=" + owner + ", "
        + "createdAt=" + createdAt
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SearchSummary) {
      SearchSummary that = (SearchSummary) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.owner.equals(that.owner())
          && this.createdAt.equals(that.createdAt());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= owner.hashCode();
    h$ *= 1000003;
    h$ ^= createdAt.hashCode();
    return h$;
  }

  @Override
  public SearchSummary.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends SearchSummary.Builder {
    private String id;
    private Optional<String> owner = Optional.empty();
    private DateTime createdAt;
    Builder() {
    }
    private Builder(SearchSummary source) {
      this.id = source.id();
      this.owner = source.owner();
      this.createdAt = source.createdAt();
    }
    @Override
    public SearchSummary.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public SearchSummary.Builder owner(@Nullable String owner) {
      this.owner = Optional.ofNullable(owner);
      return this;
    }
    @Override
    public SearchSummary.Builder createdAt(DateTime createdAt) {
      if (createdAt == null) {
        throw new NullPointerException("Null createdAt");
      }
      this.createdAt = createdAt;
      return this;
    }
    @Override
    SearchSummary autoBuild() {
      String missing = "";
      if (this.createdAt == null) {
        missing += " createdAt";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SearchSummary(
          this.id,
          this.owner,
          this.createdAt);
    }
  }

}
