package org.graylog.plugins.views.search.engine;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QueryExecutionStats extends QueryExecutionStats {

  private final long duration;

  private final DateTime timestamp;

  private final AbsoluteRange effectiveTimeRange;

  private AutoValue_QueryExecutionStats(
      long duration,
      DateTime timestamp,
      AbsoluteRange effectiveTimeRange) {
    this.duration = duration;
    this.timestamp = timestamp;
    this.effectiveTimeRange = effectiveTimeRange;
  }

  @JsonProperty("duration")
  @Override
  public long duration() {
    return duration;
  }

  @JsonProperty("timestamp")
  @Override
  public DateTime timestamp() {
    return timestamp;
  }

  @JsonProperty("effective_timerange")
  @Override
  public AbsoluteRange effectiveTimeRange() {
    return effectiveTimeRange;
  }

  @Override
  public String toString() {
    return "QueryExecutionStats{"
        + "duration=" + duration + ", "
        + "timestamp=" + timestamp + ", "
        + "effectiveTimeRange=" + effectiveTimeRange
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryExecutionStats) {
      QueryExecutionStats that = (QueryExecutionStats) o;
      return this.duration == that.duration()
          && this.timestamp.equals(that.timestamp())
          && this.effectiveTimeRange.equals(that.effectiveTimeRange());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (int) ((duration >>> 32) ^ duration);
    h$ *= 1000003;
    h$ ^= timestamp.hashCode();
    h$ *= 1000003;
    h$ ^= effectiveTimeRange.hashCode();
    return h$;
  }

  @Override
  public QueryExecutionStats.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends QueryExecutionStats.Builder {
    private Long duration;
    private DateTime timestamp;
    private AbsoluteRange effectiveTimeRange;
    Builder() {
    }
    private Builder(QueryExecutionStats source) {
      this.duration = source.duration();
      this.timestamp = source.timestamp();
      this.effectiveTimeRange = source.effectiveTimeRange();
    }
    @Override
    public QueryExecutionStats.Builder duration(long duration) {
      this.duration = duration;
      return this;
    }
    @Override
    public QueryExecutionStats.Builder timestamp(DateTime timestamp) {
      if (timestamp == null) {
        throw new NullPointerException("Null timestamp");
      }
      this.timestamp = timestamp;
      return this;
    }
    @Override
    public QueryExecutionStats.Builder effectiveTimeRange(AbsoluteRange effectiveTimeRange) {
      if (effectiveTimeRange == null) {
        throw new NullPointerException("Null effectiveTimeRange");
      }
      this.effectiveTimeRange = effectiveTimeRange;
      return this;
    }
    @Override
    public QueryExecutionStats build() {
      String missing = "";
      if (this.duration == null) {
        missing += " duration";
      }
      if (this.timestamp == null) {
        missing += " timestamp";
      }
      if (this.effectiveTimeRange == null) {
        missing += " effectiveTimeRange";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QueryExecutionStats(
          this.duration,
          this.timestamp,
          this.effectiveTimeRange);
    }
  }

}
