package org.graylog.plugins.views.search.events;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Generated;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MessagesExportEvent extends MessagesExportEvent {

  private final String userName;

  private final String auditType;

  private final DateTime timestamp;

  private final AbsoluteRange timeRange;

  private final String queryString;

  private final Set<String> streams;

  private final LinkedHashSet<String> fieldsInOrder;

  private final OptionalInt limit;

  private final Optional<String> searchId;

  private final Optional<String> searchTypeId;

  private AutoValue_MessagesExportEvent(
      String userName,
      String auditType,
      DateTime timestamp,
      AbsoluteRange timeRange,
      String queryString,
      Set<String> streams,
      LinkedHashSet<String> fieldsInOrder,
      OptionalInt limit,
      Optional<String> searchId,
      Optional<String> searchTypeId) {
    this.userName = userName;
    this.auditType = auditType;
    this.timestamp = timestamp;
    this.timeRange = timeRange;
    this.queryString = queryString;
    this.streams = streams;
    this.fieldsInOrder = fieldsInOrder;
    this.limit = limit;
    this.searchId = searchId;
    this.searchTypeId = searchTypeId;
  }

  @Override
  public String userName() {
    return userName;
  }

  @Override
  public String auditType() {
    return auditType;
  }

  @Override
  public DateTime timestamp() {
    return timestamp;
  }

  @Override
  public AbsoluteRange timeRange() {
    return timeRange;
  }

  @Override
  public String queryString() {
    return queryString;
  }

  @Override
  public Set<String> streams() {
    return streams;
  }

  @Override
  public LinkedHashSet<String> fieldsInOrder() {
    return fieldsInOrder;
  }

  @Override
  public OptionalInt limit() {
    return limit;
  }

  @Override
  public Optional<String> searchId() {
    return searchId;
  }

  @Override
  public Optional<String> searchTypeId() {
    return searchTypeId;
  }

  @Override
  public String toString() {
    return "MessagesExportEvent{"
        + "userName=" + userName + ", "
        + "auditType=" + auditType + ", "
        + "timestamp=" + timestamp + ", "
        + "timeRange=" + timeRange + ", "
        + "queryString=" + queryString + ", "
        + "streams=" + streams + ", "
        + "fieldsInOrder=" + fieldsInOrder + ", "
        + "limit=" + limit + ", "
        + "searchId=" + searchId + ", "
        + "searchTypeId=" + searchTypeId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MessagesExportEvent) {
      MessagesExportEvent that = (MessagesExportEvent) o;
      return this.userName.equals(that.userName())
          && this.auditType.equals(that.auditType())
          && this.timestamp.equals(that.timestamp())
          && this.timeRange.equals(that.timeRange())
          && this.queryString.equals(that.queryString())
          && this.streams.equals(that.streams())
          && this.fieldsInOrder.equals(that.fieldsInOrder())
          && this.limit.equals(that.limit())
          && this.searchId.equals(that.searchId())
          && this.searchTypeId.equals(that.searchTypeId());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= userName.hashCode();
    h$ *= 1000003;
    h$ ^= auditType.hashCode();
    h$ *= 1000003;
    h$ ^= timestamp.hashCode();
    h$ *= 1000003;
    h$ ^= timeRange.hashCode();
    h$ *= 1000003;
    h$ ^= queryString.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= fieldsInOrder.hashCode();
    h$ *= 1000003;
    h$ ^= limit.hashCode();
    h$ *= 1000003;
    h$ ^= searchId.hashCode();
    h$ *= 1000003;
    h$ ^= searchTypeId.hashCode();
    return h$;
  }

  @Override
  public MessagesExportEvent.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends MessagesExportEvent.Builder {
    private String userName;
    private String auditType;
    private DateTime timestamp;
    private AbsoluteRange timeRange;
    private String queryString;
    private Set<String> streams;
    private LinkedHashSet<String> fieldsInOrder;
    private OptionalInt limit = OptionalInt.empty();
    private Optional<String> searchId = Optional.empty();
    private Optional<String> searchTypeId = Optional.empty();
    Builder() {
    }
    private Builder(MessagesExportEvent source) {
      this.userName = source.userName();
      this.auditType = source.auditType();
      this.timestamp = source.timestamp();
      this.timeRange = source.timeRange();
      this.queryString = source.queryString();
      this.streams = source.streams();
      this.fieldsInOrder = source.fieldsInOrder();
      this.limit = source.limit();
      this.searchId = source.searchId();
      this.searchTypeId = source.searchTypeId();
    }
    @Override
    public MessagesExportEvent.Builder userName(String userName) {
      if (userName == null) {
        throw new NullPointerException("Null userName");
      }
      this.userName = userName;
      return this;
    }
    @Override
    public MessagesExportEvent.Builder auditType(String auditType) {
      if (auditType == null) {
        throw new NullPointerException("Null auditType");
      }
      this.auditType = auditType;
      return this;
    }
    @Override
    public MessagesExportEvent.Builder timestamp(DateTime timestamp) {
      if (timestamp == null) {
        throw new NullPointerException("Null timestamp");
      }
      this.timestamp = timestamp;
      return this;
    }
    @Override
    public MessagesExportEvent.Builder timeRange(AbsoluteRange timeRange) {
      if (timeRange == null) {
        throw new NullPointerException("Null timeRange");
      }
      this.timeRange = timeRange;
      return this;
    }
    @Override
    public MessagesExportEvent.Builder queryString(String queryString) {
      if (queryString == null) {
        throw new NullPointerException("Null queryString");
      }
      this.queryString = queryString;
      return this;
    }
    @Override
    public MessagesExportEvent.Builder streams(Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    public MessagesExportEvent.Builder fieldsInOrder(LinkedHashSet<String> fieldsInOrder) {
      if (fieldsInOrder == null) {
        throw new NullPointerException("Null fieldsInOrder");
      }
      this.fieldsInOrder = fieldsInOrder;
      return this;
    }
    @Override
    public MessagesExportEvent.Builder limit(Integer limit) {
      this.limit = OptionalInt.of(limit);
      return this;
    }
    @Override
    public MessagesExportEvent.Builder searchId(String searchId) {
      this.searchId = Optional.of(searchId);
      return this;
    }
    @Override
    public MessagesExportEvent.Builder searchTypeId(String searchTypeId) {
      this.searchTypeId = Optional.of(searchTypeId);
      return this;
    }
    @Override
    MessagesExportEvent autoBuild() {
      String missing = "";
      if (this.userName == null) {
        missing += " userName";
      }
      if (this.auditType == null) {
        missing += " auditType";
      }
      if (this.timestamp == null) {
        missing += " timestamp";
      }
      if (this.timeRange == null) {
        missing += " timeRange";
      }
      if (this.queryString == null) {
        missing += " queryString";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.fieldsInOrder == null) {
        missing += " fieldsInOrder";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MessagesExportEvent(
          this.userName,
          this.auditType,
          this.timestamp,
          this.timeRange,
          this.queryString,
          this.streams,
          this.fieldsInOrder,
          this.limit,
          this.searchId,
          this.searchTypeId);
    }
  }

}
