package org.graylog.plugins.views.search.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashSet;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Positive;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MessagesRequest extends MessagesRequest {

  private final TimeRange timeRange;

  private final ElasticsearchQueryString queryString;

  private final Set<String> streams;

  private final @NotEmpty LinkedHashSet<String> fieldsInOrder;

  private final int chunkSize;

  private final @Positive OptionalInt limit;

  private AutoValue_MessagesRequest(
      TimeRange timeRange,
      ElasticsearchQueryString queryString,
      Set<String> streams,
      @NotEmpty LinkedHashSet<String> fieldsInOrder,
      int chunkSize,
      @Positive OptionalInt limit) {
    this.timeRange = timeRange;
    this.queryString = queryString;
    this.streams = streams;
    this.fieldsInOrder = fieldsInOrder;
    this.chunkSize = chunkSize;
    this.limit = limit;
  }

  @JsonProperty("timerange")
  @Override
  public TimeRange timeRange() {
    return timeRange;
  }

  @JsonProperty("query_string")
  @Override
  public ElasticsearchQueryString queryString() {
    return queryString;
  }

  @JsonProperty
  @Override
  public Set<String> streams() {
    return streams;
  }

  @JsonProperty("fields_in_order")
  @Override
  public @NotEmpty LinkedHashSet<String> fieldsInOrder() {
    return fieldsInOrder;
  }

  @JsonProperty("chunk_size")
  @Override
  public int chunkSize() {
    return chunkSize;
  }

  @JsonProperty
  @Override
  public @Positive OptionalInt limit() {
    return limit;
  }

  @Override
  public String toString() {
    return "MessagesRequest{"
        + "timeRange=" + timeRange + ", "
        + "queryString=" + queryString + ", "
        + "streams=" + streams + ", "
        + "fieldsInOrder=" + fieldsInOrder + ", "
        + "chunkSize=" + chunkSize + ", "
        + "limit=" + limit
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MessagesRequest) {
      MessagesRequest that = (MessagesRequest) o;
      return this.timeRange.equals(that.timeRange())
          && this.queryString.equals(that.queryString())
          && this.streams.equals(that.streams())
          && this.fieldsInOrder.equals(that.fieldsInOrder())
          && this.chunkSize == that.chunkSize()
          && this.limit.equals(that.limit());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= timeRange.hashCode();
    h$ *= 1000003;
    h$ ^= queryString.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= fieldsInOrder.hashCode();
    h$ *= 1000003;
    h$ ^= chunkSize;
    h$ *= 1000003;
    h$ ^= limit.hashCode();
    return h$;
  }

  @Override
  public MessagesRequest.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends MessagesRequest.Builder {
    private TimeRange timeRange;
    private ElasticsearchQueryString queryString;
    private Set<String> streams;
    private @NotEmpty LinkedHashSet<String> fieldsInOrder;
    private Integer chunkSize;
    private @Positive OptionalInt limit = OptionalInt.empty();
    Builder() {
    }
    private Builder(MessagesRequest source) {
      this.timeRange = source.timeRange();
      this.queryString = source.queryString();
      this.streams = source.streams();
      this.fieldsInOrder = source.fieldsInOrder();
      this.chunkSize = source.chunkSize();
      this.limit = source.limit();
    }
    @Override
    public MessagesRequest.Builder timeRange(TimeRange timeRange) {
      if (timeRange == null) {
        throw new NullPointerException("Null timeRange");
      }
      this.timeRange = timeRange;
      return this;
    }
    @Override
    public MessagesRequest.Builder queryString(ElasticsearchQueryString queryString) {
      if (queryString == null) {
        throw new NullPointerException("Null queryString");
      }
      this.queryString = queryString;
      return this;
    }
    @Override
    public MessagesRequest.Builder streams(Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    public MessagesRequest.Builder fieldsInOrder(LinkedHashSet<String> fieldsInOrder) {
      if (fieldsInOrder == null) {
        throw new NullPointerException("Null fieldsInOrder");
      }
      this.fieldsInOrder = fieldsInOrder;
      return this;
    }
    @Override
    public MessagesRequest.Builder chunkSize(int chunkSize) {
      this.chunkSize = chunkSize;
      return this;
    }
    @Override
    public MessagesRequest.Builder limit(Integer limit) {
      this.limit = OptionalInt.of(limit);
      return this;
    }
    @Override
    public MessagesRequest build() {
      String missing = "";
      if (this.timeRange == null) {
        missing += " timeRange";
      }
      if (this.queryString == null) {
        missing += " queryString";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.fieldsInOrder == null) {
        missing += " fieldsInOrder";
      }
      if (this.chunkSize == null) {
        missing += " chunkSize";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MessagesRequest(
          this.timeRange,
          this.queryString,
          this.streams,
          this.fieldsInOrder,
          this.chunkSize,
          this.limit);
    }
  }

}
