package org.graylog.plugins.views.search.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Positive;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ResultFormat extends ResultFormat {

  private final @NotEmpty LinkedHashSet<String> fieldsInOrder;

  private final Optional<AbsoluteRange> timerange;

  private final Optional<Integer> limit;

  private final Map<String, Object> executionState;

  private final Optional<String> filename;

  private AutoValue_ResultFormat(
      @NotEmpty LinkedHashSet<String> fieldsInOrder,
      Optional<AbsoluteRange> timerange,
      Optional<Integer> limit,
      Map<String, Object> executionState,
      Optional<String> filename) {
    this.fieldsInOrder = fieldsInOrder;
    this.timerange = timerange;
    this.limit = limit;
    this.executionState = executionState;
    this.filename = filename;
  }

  @JsonProperty("fields_in_order")
  @Override
  public @NotEmpty LinkedHashSet<String> fieldsInOrder() {
    return fieldsInOrder;
  }

  @JsonProperty
  @Override
  public Optional<AbsoluteRange> timerange() {
    return timerange;
  }

  @JsonProperty
  @Override
  public Optional<Integer> limit() {
    return limit;
  }

  @JsonProperty
  @Override
  public Map<String, Object> executionState() {
    return executionState;
  }

  @JsonProperty
  @Override
  public Optional<String> filename() {
    return filename;
  }

  @Override
  public String toString() {
    return "ResultFormat{"
        + "fieldsInOrder=" + fieldsInOrder + ", "
        + "timerange=" + timerange + ", "
        + "limit=" + limit + ", "
        + "executionState=" + executionState + ", "
        + "filename=" + filename
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ResultFormat) {
      ResultFormat that = (ResultFormat) o;
      return this.fieldsInOrder.equals(that.fieldsInOrder())
          && this.timerange.equals(that.timerange())
          && this.limit.equals(that.limit())
          && this.executionState.equals(that.executionState())
          && this.filename.equals(that.filename());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= fieldsInOrder.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= limit.hashCode();
    h$ *= 1000003;
    h$ ^= executionState.hashCode();
    h$ *= 1000003;
    h$ ^= filename.hashCode();
    return h$;
  }

  static final class Builder extends ResultFormat.Builder {
    private @NotEmpty LinkedHashSet<String> fieldsInOrder;
    private Optional<AbsoluteRange> timerange = Optional.empty();
    private Optional<Integer> limit = Optional.empty();
    private Map<String, Object> executionState;
    private Optional<String> filename = Optional.empty();
    Builder() {
    }
    @Override
    public ResultFormat.Builder fieldsInOrder(LinkedHashSet<String> fieldsInOrder) {
      if (fieldsInOrder == null) {
        throw new NullPointerException("Null fieldsInOrder");
      }
      this.fieldsInOrder = fieldsInOrder;
      return this;
    }
    @Override
    public ResultFormat.Builder timerange(@Nullable AbsoluteRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    public ResultFormat.Builder limit(@Nullable @Positive Integer limit) {
      this.limit = Optional.ofNullable(limit);
      return this;
    }
    @Override
    public ResultFormat.Builder executionState(Map<String, Object> executionState) {
      if (executionState == null) {
        throw new NullPointerException("Null executionState");
      }
      this.executionState = executionState;
      return this;
    }
    @Override
    public ResultFormat.Builder filename(@Nullable String filename) {
      this.filename = Optional.ofNullable(filename);
      return this;
    }
    @Override
    public ResultFormat build() {
      String missing = "";
      if (this.fieldsInOrder == null) {
        missing += " fieldsInOrder";
      }
      if (this.executionState == null) {
        missing += " executionState";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ResultFormat(
          this.fieldsInOrder,
          this.timerange,
          this.limit,
          this.executionState,
          this.filename);
    }
  }

}
