package org.graylog.plugins.views.search.filter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_StreamFilter extends StreamFilter {

  private final String type;

  private final Set<Filter> filters;

  private final String streamId;

  private final String streamTitle;

  private AutoValue_StreamFilter(
      String type,
      @Nullable Set<Filter> filters,
      @Nullable String streamId,
      @Nullable String streamTitle) {
    this.type = type;
    this.filters = filters;
    this.streamId = streamId;
    this.streamTitle = streamTitle;
  }

  @JsonProperty
  @Override
  public String type() {
    return type;
  }

  @Nullable
  @JsonProperty
  @JsonInclude(JsonInclude.Include.NON_NULL)
  @Override
  public Set<Filter> filters() {
    return filters;
  }

  @Nullable
  @JsonProperty("id")
  @Override
  public String streamId() {
    return streamId;
  }

  @Nullable
  @JsonProperty("title")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  @Override
  public String streamTitle() {
    return streamTitle;
  }

  @Override
  public String toString() {
    return "StreamFilter{"
        + "type=" + type + ", "
        + "filters=" + filters + ", "
        + "streamId=" + streamId + ", "
        + "streamTitle=" + streamTitle
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof StreamFilter) {
      StreamFilter that = (StreamFilter) o;
      return this.type.equals(that.type())
          && (this.filters == null ? that.filters() == null : this.filters.equals(that.filters()))
          && (this.streamId == null ? that.streamId() == null : this.streamId.equals(that.streamId()))
          && (this.streamTitle == null ? that.streamTitle() == null : this.streamTitle.equals(that.streamTitle()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (filters == null) ? 0 : filters.hashCode();
    h$ *= 1000003;
    h$ ^= (streamId == null) ? 0 : streamId.hashCode();
    h$ *= 1000003;
    h$ ^= (streamTitle == null) ? 0 : streamTitle.hashCode();
    return h$;
  }

  @Override
  public StreamFilter.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends StreamFilter.Builder {
    private String type;
    private Set<Filter> filters;
    private String streamId;
    private String streamTitle;
    Builder() {
    }
    private Builder(StreamFilter source) {
      this.type = source.type();
      this.filters = source.filters();
      this.streamId = source.streamId();
      this.streamTitle = source.streamTitle();
    }
    @Override
    public StreamFilter.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public StreamFilter.Builder filters(@Nullable Set<Filter> filters) {
      this.filters = filters;
      return this;
    }
    @Override
    public StreamFilter.Builder streamId(@Nullable String streamId) {
      this.streamId = streamId;
      return this;
    }
    @Override
    public StreamFilter.Builder streamTitle(@Nullable String streamTitle) {
      this.streamTitle = streamTitle;
      return this;
    }
    @Override
    public StreamFilter build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_StreamFilter(
          this.type,
          this.filters,
          this.streamId,
          this.streamTitle);
    }
  }

}
