package org.graylog.plugins.views.search.searchtypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog2.decorators.Decorator;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MessageList extends MessageList {

  private final Optional<DerivedTimeRange> timerange;

  private final Optional<BackendQuery> query;

  private final Set<String> streams;

  private final String type;

  private final String id;

  private final Optional<String> name;

  private final Filter filter;

  private final int limit;

  private final int offset;

  private final List<Sort> sort;

  private final List<Decorator> decorators;

  private AutoValue_MessageList(
      Optional<DerivedTimeRange> timerange,
      Optional<BackendQuery> query,
      Set<String> streams,
      String type,
      @Nullable String id,
      Optional<String> name,
      @Nullable Filter filter,
      int limit,
      int offset,
      @Nullable List<Sort> sort,
      List<Decorator> decorators) {
    this.timerange = timerange;
    this.query = query;
    this.streams = streams;
    this.type = type;
    this.id = id;
    this.name = name;
    this.filter = filter;
    this.limit = limit;
    this.offset = offset;
    this.sort = sort;
    this.decorators = decorators;
  }

  @JsonProperty
  @Override
  public Optional<DerivedTimeRange> timerange() {
    return timerange;
  }

  @JsonProperty
  @Override
  public Optional<BackendQuery> query() {
    return query;
  }

  @JsonProperty
  @Override
  public Set<String> streams() {
    return streams;
  }

  @Override
  public String type() {
    return type;
  }

  @Nullable
  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public Optional<String> name() {
    return name;
  }

  @Nullable
  @Override
  public Filter filter() {
    return filter;
  }

  @JsonProperty
  @Override
  public int limit() {
    return limit;
  }

  @JsonProperty
  @Override
  public int offset() {
    return offset;
  }

  @Nullable
  @JsonProperty
  @Override
  public List<Sort> sort() {
    return sort;
  }

  @JsonProperty
  @Override
  public List<Decorator> decorators() {
    return decorators;
  }

  @Override
  public String toString() {
    return "MessageList{"
        + "timerange=" + timerange + ", "
        + "query=" + query + ", "
        + "streams=" + streams + ", "
        + "type=" + type + ", "
        + "id=" + id + ", "
        + "name=" + name + ", "
        + "filter=" + filter + ", "
        + "limit=" + limit + ", "
        + "offset=" + offset + ", "
        + "sort=" + sort + ", "
        + "decorators=" + decorators
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MessageList) {
      MessageList that = (MessageList) o;
      return this.timerange.equals(that.timerange())
          && this.query.equals(that.query())
          && this.streams.equals(that.streams())
          && this.type.equals(that.type())
          && (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.name.equals(that.name())
          && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter()))
          && this.limit == that.limit()
          && this.offset == that.offset()
          && (this.sort == null ? that.sort() == null : this.sort.equals(that.sort()))
          && this.decorators.equals(that.decorators());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= (filter == null) ? 0 : filter.hashCode();
    h$ *= 1000003;
    h$ ^= limit;
    h$ *= 1000003;
    h$ ^= offset;
    h$ *= 1000003;
    h$ ^= (sort == null) ? 0 : sort.hashCode();
    h$ *= 1000003;
    h$ ^= decorators.hashCode();
    return h$;
  }

  @Override
  public MessageList.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends MessageList.Builder {
    private Optional<DerivedTimeRange> timerange = Optional.empty();
    private Optional<BackendQuery> query = Optional.empty();
    private Set<String> streams;
    private String type;
    private String id;
    private Optional<String> name = Optional.empty();
    private Filter filter;
    private Integer limit;
    private Integer offset;
    private List<Sort> sort;
    private List<Decorator> decorators;
    Builder() {
    }
    private Builder(MessageList source) {
      this.timerange = source.timerange();
      this.query = source.query();
      this.streams = source.streams();
      this.type = source.type();
      this.id = source.id();
      this.name = source.name();
      this.filter = source.filter();
      this.limit = source.limit();
      this.offset = source.offset();
      this.sort = source.sort();
      this.decorators = source.decorators();
    }
    @Override
    public MessageList.Builder timerange(@Nullable DerivedTimeRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    public MessageList.Builder query(@Nullable BackendQuery query) {
      this.query = Optional.ofNullable(query);
      return this;
    }
    @Override
    public MessageList.Builder streams(Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    public MessageList.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public MessageList.Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }
    @Override
    public MessageList.Builder name(@Nullable String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }
    @Override
    public MessageList.Builder filter(@Nullable Filter filter) {
      this.filter = filter;
      return this;
    }
    @Override
    public MessageList.Builder limit(int limit) {
      this.limit = limit;
      return this;
    }
    @Override
    public MessageList.Builder offset(int offset) {
      this.offset = offset;
      return this;
    }
    @Override
    public MessageList.Builder sort(@Nullable List<Sort> sort) {
      this.sort = sort;
      return this;
    }
    @Override
    public MessageList.Builder decorators(List<Decorator> decorators) {
      if (decorators == null) {
        throw new NullPointerException("Null decorators");
      }
      this.decorators = decorators;
      return this;
    }
    @Override
    public MessageList build() {
      String missing = "";
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (this.limit == null) {
        missing += " limit";
      }
      if (this.offset == null) {
        missing += " offset";
      }
      if (this.decorators == null) {
        missing += " decorators";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MessageList(
          this.timerange,
          this.query,
          this.streams,
          this.type,
          this.id,
          this.name,
          this.filter,
          this.limit,
          this.offset,
          this.sort,
          this.decorators);
    }
  }

}
