package org.graylog.plugins.views.search.searchtypes.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Generated;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventSummary extends EventSummary {

  private final String id;

  private final Set<String> streams;

  private final DateTime timestamp;

  private final String message;

  private final boolean alert;

  private AutoValue_EventSummary(
      String id,
      Set<String> streams,
      DateTime timestamp,
      String message,
      boolean alert) {
    this.id = id;
    this.streams = streams;
    this.timestamp = timestamp;
    this.message = message;
    this.alert = alert;
  }

  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("streams")
  @Override
  public Set<String> streams() {
    return streams;
  }

  @JsonProperty("timestamp")
  @Override
  public DateTime timestamp() {
    return timestamp;
  }

  @JsonProperty("message")
  @Override
  public String message() {
    return message;
  }

  @JsonProperty("alert")
  @Override
  public boolean alert() {
    return alert;
  }

  @Override
  public String toString() {
    return "EventSummary{"
        + "id=" + id + ", "
        + "streams=" + streams + ", "
        + "timestamp=" + timestamp + ", "
        + "message=" + message + ", "
        + "alert=" + alert
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventSummary) {
      EventSummary that = (EventSummary) o;
      return this.id.equals(that.id())
          && this.streams.equals(that.streams())
          && this.timestamp.equals(that.timestamp())
          && this.message.equals(that.message())
          && this.alert == that.alert();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= timestamp.hashCode();
    h$ *= 1000003;
    h$ ^= message.hashCode();
    h$ *= 1000003;
    h$ ^= alert ? 1231 : 1237;
    return h$;
  }

  @Override
  public EventSummary.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventSummary.Builder {
    private String id;
    private Set<String> streams;
    private DateTime timestamp;
    private String message;
    private Boolean alert;
    Builder() {
    }
    private Builder(EventSummary source) {
      this.id = source.id();
      this.streams = source.streams();
      this.timestamp = source.timestamp();
      this.message = source.message();
      this.alert = source.alert();
    }
    @Override
    public EventSummary.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public EventSummary.Builder streams(Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    public EventSummary.Builder timestamp(DateTime timestamp) {
      if (timestamp == null) {
        throw new NullPointerException("Null timestamp");
      }
      this.timestamp = timestamp;
      return this;
    }
    @Override
    public EventSummary.Builder message(String message) {
      if (message == null) {
        throw new NullPointerException("Null message");
      }
      this.message = message;
      return this;
    }
    @Override
    public EventSummary.Builder alert(boolean alert) {
      this.alert = alert;
      return this;
    }
    @Override
    public EventSummary build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.timestamp == null) {
        missing += " timestamp";
      }
      if (this.message == null) {
        missing += " message";
      }
      if (this.alert == null) {
        missing += " alert";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventSummary(
          this.id,
          this.streams,
          this.timestamp,
          this.message,
          this.alert);
    }
  }

}
