package org.graylog.plugins.views.search.searchtypes.pivot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.Generated;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PivotResult extends PivotResult {

  private final Optional<String> name;

  private final String id;

  private final ImmutableList<PivotResult.Row> rows;

  private final long total;

  private final AbsoluteRange effectiveTimerange;

  private AutoValue_PivotResult(
      Optional<String> name,
      String id,
      ImmutableList<PivotResult.Row> rows,
      long total,
      AbsoluteRange effectiveTimerange) {
    this.name = name;
    this.id = id;
    this.rows = rows;
    this.total = total;
    this.effectiveTimerange = effectiveTimerange;
  }

  @JsonProperty
  @Override
  public Optional<String> name() {
    return name;
  }

  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public ImmutableList<PivotResult.Row> rows() {
    return rows;
  }

  @JsonProperty
  @Override
  public long total() {
    return total;
  }

  @JsonProperty("effective_timerange")
  @Override
  public AbsoluteRange effectiveTimerange() {
    return effectiveTimerange;
  }

  @Override
  public String toString() {
    return "PivotResult{"
        + "name=" + name + ", "
        + "id=" + id + ", "
        + "rows=" + rows + ", "
        + "total=" + total + ", "
        + "effectiveTimerange=" + effectiveTimerange
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PivotResult) {
      PivotResult that = (PivotResult) o;
      return this.name.equals(that.name())
          && this.id.equals(that.id())
          && this.rows.equals(that.rows())
          && this.total == that.total()
          && this.effectiveTimerange.equals(that.effectiveTimerange());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= rows.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((total >>> 32) ^ total);
    h$ *= 1000003;
    h$ ^= effectiveTimerange.hashCode();
    return h$;
  }

  static final class Builder extends PivotResult.Builder {
    private Optional<String> name = Optional.empty();
    private String id;
    private ImmutableList.Builder<PivotResult.Row> rowsBuilder$;
    private ImmutableList<PivotResult.Row> rows;
    private Long total;
    private AbsoluteRange effectiveTimerange;
    Builder() {
    }
    @Override
    public PivotResult.Builder name(String name) {
      this.name = Optional.of(name);
      return this;
    }
    @Override
    public PivotResult.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    ImmutableList.Builder<PivotResult.Row> rowsBuilder() {
      if (rowsBuilder$ == null) {
        rowsBuilder$ = ImmutableList.builder();
      }
      return rowsBuilder$;
    }
    @Override
    public PivotResult.Builder total(long total) {
      this.total = total;
      return this;
    }
    @Override
    public PivotResult.Builder effectiveTimerange(AbsoluteRange effectiveTimerange) {
      if (effectiveTimerange == null) {
        throw new NullPointerException("Null effectiveTimerange");
      }
      this.effectiveTimerange = effectiveTimerange;
      return this;
    }
    @Override
    public PivotResult build() {
      if (rowsBuilder$ != null) {
        this.rows = rowsBuilder$.build();
      } else if (this.rows == null) {
        this.rows = ImmutableList.of();
      }
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.total == null) {
        missing += " total";
      }
      if (this.effectiveTimerange == null) {
        missing += " effectiveTimerange";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PivotResult(
          this.name,
          this.id,
          this.rows,
          this.total,
          this.effectiveTimerange);
    }
  }

}
