package org.graylog.plugins.views.search.timeranges;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_OffsetRange extends OffsetRange {

  private final String type;

  private final String source;

  private final Optional<String> id;

  private final String offset;

  private AutoValue_OffsetRange(
      String type,
      String source,
      Optional<String> id,
      String offset) {
    this.type = type;
    this.source = source;
    this.id = id;
    this.offset = offset;
  }

  @JsonProperty
  @Override
  public String type() {
    return type;
  }

  @JsonProperty
  @Override
  public String source() {
    return source;
  }

  @JsonProperty
  @Override
  public Optional<String> id() {
    return id;
  }

  @JsonProperty
  @Override
  public String offset() {
    return offset;
  }

  @Override
  public String toString() {
    return "OffsetRange{"
        + "type=" + type + ", "
        + "source=" + source + ", "
        + "id=" + id + ", "
        + "offset=" + offset
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof OffsetRange) {
      OffsetRange that = (OffsetRange) o;
      return this.type.equals(that.type())
          && this.source.equals(that.source())
          && this.id.equals(that.id())
          && this.offset.equals(that.offset());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= source.hashCode();
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= offset.hashCode();
    return h$;
  }

  static final class Builder extends OffsetRange.Builder {
    private String type;
    private String source;
    private Optional<String> id = Optional.empty();
    private String offset;
    Builder() {
    }
    @Override
    public OffsetRange.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public OffsetRange.Builder source(String source) {
      if (source == null) {
        throw new NullPointerException("Null source");
      }
      this.source = source;
      return this;
    }
    @Override
    public OffsetRange.Builder id(@Nullable String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }
    @Override
    public OffsetRange.Builder offset(String offset) {
      if (offset == null) {
        throw new NullPointerException("Null offset");
      }
      this.offset = offset;
      return this;
    }
    @Override
    public OffsetRange build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.source == null) {
        missing += " source";
      }
      if (this.offset == null) {
        missing += " offset";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_OffsetRange(
          this.type,
          this.source,
          this.id,
          this.offset);
    }
  }

}
