package org.graylog.plugins.views.search.views;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableSet;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_ViewSummaryDTO extends $AutoValue_ViewSummaryDTO {
  AutoValue_ViewSummaryDTO(String id, ViewDTO.Type type, String title, String summary,
      String description, String searchId, ImmutableSet<String> properties,
      Map<String, PluginMetadataSummary> requires, Optional<String> owner, DateTime createdAt) {
    super(id, type, title, summary, description, searchId, properties, requires, owner, createdAt);
  }

  @JsonIgnore
  @ObjectId
  @Id
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  public final ViewDTO.Type getType() {
    return type();
  }

  @JsonIgnore
  @NotBlank
  public final String getTitle() {
    return title();
  }

  @JsonIgnore
  public final String getSummary() {
    return summary();
  }

  @JsonIgnore
  public final String getDescription() {
    return description();
  }

  @JsonIgnore
  public final String getSearchId() {
    return searchId();
  }

  @JsonIgnore
  public final ImmutableSet<String> getProperties() {
    return properties();
  }

  @JsonIgnore
  public final Map<String, PluginMetadataSummary> getRequires() {
    return requires();
  }

  @JsonIgnore
  public final Optional<String> getOwner() {
    return owner();
  }

  @JsonIgnore
  public final DateTime getCreatedAt() {
    return createdAt();
  }
}
