package org.graylog.plugins.views.search.views.widgets.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.views.widgets.aggregation.sort.SortConfigDTO;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AggregationConfigDTO extends AggregationConfigDTO {

  private final List<PivotDTO> rowPivots;

  private final List<PivotDTO> columnPivots;

  private final List<SeriesDTO> series;

  private final List<SortConfigDTO> sort;

  private final String visualization;

  private final VisualizationConfigDTO visualizationConfig;

  private final WidgetFormattingSettings formattingSettings;

  private final boolean rollup;

  private final boolean eventAnnotation;

  private AutoValue_AggregationConfigDTO(
      List<PivotDTO> rowPivots,
      List<PivotDTO> columnPivots,
      List<SeriesDTO> series,
      List<SortConfigDTO> sort,
      String visualization,
      @Nullable VisualizationConfigDTO visualizationConfig,
      @Nullable WidgetFormattingSettings formattingSettings,
      boolean rollup,
      boolean eventAnnotation) {
    this.rowPivots = rowPivots;
    this.columnPivots = columnPivots;
    this.series = series;
    this.sort = sort;
    this.visualization = visualization;
    this.visualizationConfig = visualizationConfig;
    this.formattingSettings = formattingSettings;
    this.rollup = rollup;
    this.eventAnnotation = eventAnnotation;
  }

  @JsonProperty("row_pivots")
  @Override
  public List<PivotDTO> rowPivots() {
    return rowPivots;
  }

  @JsonProperty("column_pivots")
  @Override
  public List<PivotDTO> columnPivots() {
    return columnPivots;
  }

  @JsonProperty("series")
  @Override
  public List<SeriesDTO> series() {
    return series;
  }

  @JsonProperty("sort")
  @Override
  public List<SortConfigDTO> sort() {
    return sort;
  }

  @JsonProperty("visualization")
  @Override
  public String visualization() {
    return visualization;
  }

  @JsonProperty("visualization_config")
  @Nullable
  @Override
  public VisualizationConfigDTO visualizationConfig() {
    return visualizationConfig;
  }

  @JsonProperty("formatting_settings")
  @Nullable
  @Override
  public WidgetFormattingSettings formattingSettings() {
    return formattingSettings;
  }

  @JsonProperty("rollup")
  @Override
  public boolean rollup() {
    return rollup;
  }

  @JsonProperty("event_annotation")
  @Override
  public boolean eventAnnotation() {
    return eventAnnotation;
  }

  @Override
  public String toString() {
    return "AggregationConfigDTO{"
        + "rowPivots=" + rowPivots + ", "
        + "columnPivots=" + columnPivots + ", "
        + "series=" + series + ", "
        + "sort=" + sort + ", "
        + "visualization=" + visualization + ", "
        + "visualizationConfig=" + visualizationConfig + ", "
        + "formattingSettings=" + formattingSettings + ", "
        + "rollup=" + rollup + ", "
        + "eventAnnotation=" + eventAnnotation
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AggregationConfigDTO) {
      AggregationConfigDTO that = (AggregationConfigDTO) o;
      return this.rowPivots.equals(that.rowPivots())
          && this.columnPivots.equals(that.columnPivots())
          && this.series.equals(that.series())
          && this.sort.equals(that.sort())
          && this.visualization.equals(that.visualization())
          && (this.visualizationConfig == null ? that.visualizationConfig() == null : this.visualizationConfig.equals(that.visualizationConfig()))
          && (this.formattingSettings == null ? that.formattingSettings() == null : this.formattingSettings.equals(that.formattingSettings()))
          && this.rollup == that.rollup()
          && this.eventAnnotation == that.eventAnnotation();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= rowPivots.hashCode();
    h$ *= 1000003;
    h$ ^= columnPivots.hashCode();
    h$ *= 1000003;
    h$ ^= series.hashCode();
    h$ *= 1000003;
    h$ ^= sort.hashCode();
    h$ *= 1000003;
    h$ ^= visualization.hashCode();
    h$ *= 1000003;
    h$ ^= (visualizationConfig == null) ? 0 : visualizationConfig.hashCode();
    h$ *= 1000003;
    h$ ^= (formattingSettings == null) ? 0 : formattingSettings.hashCode();
    h$ *= 1000003;
    h$ ^= rollup ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= eventAnnotation ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends AggregationConfigDTO.Builder {
    private List<PivotDTO> rowPivots;
    private List<PivotDTO> columnPivots;
    private List<SeriesDTO> series;
    private List<SortConfigDTO> sort;
    private String visualization;
    private VisualizationConfigDTO visualizationConfig;
    private WidgetFormattingSettings formattingSettings;
    private Boolean rollup;
    private Boolean eventAnnotation;
    Builder() {
    }
    @Override
    public AggregationConfigDTO.Builder rowPivots(List<PivotDTO> rowPivots) {
      if (rowPivots == null) {
        throw new NullPointerException("Null rowPivots");
      }
      this.rowPivots = rowPivots;
      return this;
    }
    @Override
    public AggregationConfigDTO.Builder columnPivots(List<PivotDTO> columnPivots) {
      if (columnPivots == null) {
        throw new NullPointerException("Null columnPivots");
      }
      this.columnPivots = columnPivots;
      return this;
    }
    @Override
    public AggregationConfigDTO.Builder series(List<SeriesDTO> series) {
      if (series == null) {
        throw new NullPointerException("Null series");
      }
      this.series = series;
      return this;
    }
    @Override
    public AggregationConfigDTO.Builder sort(List<SortConfigDTO> sort) {
      if (sort == null) {
        throw new NullPointerException("Null sort");
      }
      this.sort = sort;
      return this;
    }
    @Override
    public AggregationConfigDTO.Builder visualization(String visualization) {
      if (visualization == null) {
        throw new NullPointerException("Null visualization");
      }
      this.visualization = visualization;
      return this;
    }
    @Override
    public AggregationConfigDTO.Builder visualizationConfig(@Nullable VisualizationConfigDTO visualizationConfig) {
      this.visualizationConfig = visualizationConfig;
      return this;
    }
    @Override
    public AggregationConfigDTO.Builder formattingSettings(@Nullable WidgetFormattingSettings formattingSettings) {
      this.formattingSettings = formattingSettings;
      return this;
    }
    @Override
    public AggregationConfigDTO.Builder rollup(boolean rollup) {
      this.rollup = rollup;
      return this;
    }
    @Override
    public AggregationConfigDTO.Builder eventAnnotation(boolean eventAnnotation) {
      this.eventAnnotation = eventAnnotation;
      return this;
    }
    @Override
    public AggregationConfigDTO build() {
      String missing = "";
      if (this.rowPivots == null) {
        missing += " rowPivots";
      }
      if (this.columnPivots == null) {
        missing += " columnPivots";
      }
      if (this.series == null) {
        missing += " series";
      }
      if (this.sort == null) {
        missing += " sort";
      }
      if (this.visualization == null) {
        missing += " visualization";
      }
      if (this.rollup == null) {
        missing += " rollup";
      }
      if (this.eventAnnotation == null) {
        missing += " eventAnnotation";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AggregationConfigDTO(
          this.rowPivots,
          this.columnPivots,
          this.series,
          this.sort,
          this.visualization,
          this.visualizationConfig,
          this.formattingSettings,
          this.rollup,
          this.eventAnnotation);
    }
  }

}
