package org.graylog.scheduler;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_JobDefinitionDto extends JobDefinitionDto {

  private final String id;

  private final String title;

  private final String description;

  private final JobDefinitionConfig config;

  private AutoValue_JobDefinitionDto(
      @Nullable String id,
      String title,
      String description,
      JobDefinitionConfig config) {
    this.id = id;
    this.title = title;
    this.description = description;
    this.config = config;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("title")
  @Override
  public String title() {
    return title;
  }

  @JsonProperty("description")
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("config")
  @Override
  public JobDefinitionConfig config() {
    return config;
  }

  @Override
  public String toString() {
    return "JobDefinitionDto{"
        + "id=" + id + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "config=" + config
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof JobDefinitionDto) {
      JobDefinitionDto that = (JobDefinitionDto) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.title.equals(that.title())
          && this.description.equals(that.description())
          && this.config.equals(that.config());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= config.hashCode();
    return h$;
  }

  @Override
  public JobDefinitionDto.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends JobDefinitionDto.Builder {
    private String id;
    private String title;
    private String description;
    private JobDefinitionConfig config;
    Builder() {
    }
    private Builder(JobDefinitionDto source) {
      this.id = source.id();
      this.title = source.title();
      this.description = source.description();
      this.config = source.config();
    }
    @Override
    public JobDefinitionDto.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public JobDefinitionDto.Builder title(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public JobDefinitionDto.Builder description(String description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public JobDefinitionDto.Builder config(JobDefinitionConfig config) {
      if (config == null) {
        throw new NullPointerException("Null config");
      }
      this.config = config;
      return this;
    }
    @Override
    public JobDefinitionDto build() {
      String missing = "";
      if (this.title == null) {
        missing += " title";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (this.config == null) {
        missing += " config";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_JobDefinitionDto(
          this.id,
          this.title,
          this.description,
          this.config);
    }
  }

}
