package org.graylog.scheduler;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_JobTriggerDto extends JobTriggerDto {

  private final String id;

  private final String jobDefinitionId;

  private final DateTime startTime;

  private final Optional<DateTime> endTime;

  private final DateTime nextTime;

  private final DateTime createdAt;

  private final DateTime updatedAt;

  private final Optional<DateTime> triggeredAt;

  private final JobTriggerStatus status;

  private final JobTriggerLock lock;

  private final JobSchedule schedule;

  private final Optional<JobTriggerData> data;

  private AutoValue_JobTriggerDto(
      @Nullable String id,
      String jobDefinitionId,
      DateTime startTime,
      Optional<DateTime> endTime,
      DateTime nextTime,
      DateTime createdAt,
      DateTime updatedAt,
      Optional<DateTime> triggeredAt,
      JobTriggerStatus status,
      JobTriggerLock lock,
      JobSchedule schedule,
      Optional<JobTriggerData> data) {
    this.id = id;
    this.jobDefinitionId = jobDefinitionId;
    this.startTime = startTime;
    this.endTime = endTime;
    this.nextTime = nextTime;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.triggeredAt = triggeredAt;
    this.status = status;
    this.lock = lock;
    this.schedule = schedule;
    this.data = data;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("job_definition_id")
  @Override
  public String jobDefinitionId() {
    return jobDefinitionId;
  }

  @JsonProperty("start_time")
  @Override
  public DateTime startTime() {
    return startTime;
  }

  @JsonProperty("end_time")
  @Override
  public Optional<DateTime> endTime() {
    return endTime;
  }

  @JsonProperty("next_time")
  @Override
  public DateTime nextTime() {
    return nextTime;
  }

  @JsonProperty("created_at")
  @Override
  public DateTime createdAt() {
    return createdAt;
  }

  @JsonProperty("updated_at")
  @Override
  public DateTime updatedAt() {
    return updatedAt;
  }

  @JsonProperty("triggered_at")
  @Override
  public Optional<DateTime> triggeredAt() {
    return triggeredAt;
  }

  @JsonProperty("status")
  @Override
  public JobTriggerStatus status() {
    return status;
  }

  @JsonProperty("lock")
  @Override
  public JobTriggerLock lock() {
    return lock;
  }

  @JsonProperty("schedule")
  @Override
  public JobSchedule schedule() {
    return schedule;
  }

  @JsonProperty("data")
  @Override
  public Optional<JobTriggerData> data() {
    return data;
  }

  @Override
  public String toString() {
    return "JobTriggerDto{"
        + "id=" + id + ", "
        + "jobDefinitionId=" + jobDefinitionId + ", "
        + "startTime=" + startTime + ", "
        + "endTime=" + endTime + ", "
        + "nextTime=" + nextTime + ", "
        + "createdAt=" + createdAt + ", "
        + "updatedAt=" + updatedAt + ", "
        + "triggeredAt=" + triggeredAt + ", "
        + "status=" + status + ", "
        + "lock=" + lock + ", "
        + "schedule=" + schedule + ", "
        + "data=" + data
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof JobTriggerDto) {
      JobTriggerDto that = (JobTriggerDto) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.jobDefinitionId.equals(that.jobDefinitionId())
          && this.startTime.equals(that.startTime())
          && this.endTime.equals(that.endTime())
          && this.nextTime.equals(that.nextTime())
          && this.createdAt.equals(that.createdAt())
          && this.updatedAt.equals(that.updatedAt())
          && this.triggeredAt.equals(that.triggeredAt())
          && this.status.equals(that.status())
          && this.lock.equals(that.lock())
          && this.schedule.equals(that.schedule())
          && this.data.equals(that.data());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= jobDefinitionId.hashCode();
    h$ *= 1000003;
    h$ ^= startTime.hashCode();
    h$ *= 1000003;
    h$ ^= endTime.hashCode();
    h$ *= 1000003;
    h$ ^= nextTime.hashCode();
    h$ *= 1000003;
    h$ ^= createdAt.hashCode();
    h$ *= 1000003;
    h$ ^= updatedAt.hashCode();
    h$ *= 1000003;
    h$ ^= triggeredAt.hashCode();
    h$ *= 1000003;
    h$ ^= status.hashCode();
    h$ *= 1000003;
    h$ ^= lock.hashCode();
    h$ *= 1000003;
    h$ ^= schedule.hashCode();
    h$ *= 1000003;
    h$ ^= data.hashCode();
    return h$;
  }

  @Override
  public JobTriggerDto.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends JobTriggerDto.Builder {
    private String id;
    private String jobDefinitionId;
    private DateTime startTime;
    private Optional<DateTime> endTime = Optional.empty();
    private DateTime nextTime;
    private DateTime createdAt;
    private DateTime updatedAt;
    private Optional<DateTime> triggeredAt = Optional.empty();
    private JobTriggerStatus status;
    private JobTriggerLock lock;
    private JobSchedule schedule;
    private Optional<JobTriggerData> data = Optional.empty();
    Builder() {
    }
    private Builder(JobTriggerDto source) {
      this.id = source.id();
      this.jobDefinitionId = source.jobDefinitionId();
      this.startTime = source.startTime();
      this.endTime = source.endTime();
      this.nextTime = source.nextTime();
      this.createdAt = source.createdAt();
      this.updatedAt = source.updatedAt();
      this.triggeredAt = source.triggeredAt();
      this.status = source.status();
      this.lock = source.lock();
      this.schedule = source.schedule();
      this.data = source.data();
    }
    @Override
    public JobTriggerDto.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public JobTriggerDto.Builder jobDefinitionId(String jobDefinitionId) {
      if (jobDefinitionId == null) {
        throw new NullPointerException("Null jobDefinitionId");
      }
      this.jobDefinitionId = jobDefinitionId;
      return this;
    }
    @Override
    public JobTriggerDto.Builder startTime(DateTime startTime) {
      if (startTime == null) {
        throw new NullPointerException("Null startTime");
      }
      this.startTime = startTime;
      return this;
    }
    @Override
    public JobTriggerDto.Builder endTime(@Nullable DateTime endTime) {
      this.endTime = Optional.ofNullable(endTime);
      return this;
    }
    @Override
    public JobTriggerDto.Builder nextTime(DateTime nextTime) {
      if (nextTime == null) {
        throw new NullPointerException("Null nextTime");
      }
      this.nextTime = nextTime;
      return this;
    }
    @Override
    public JobTriggerDto.Builder createdAt(DateTime createdAt) {
      if (createdAt == null) {
        throw new NullPointerException("Null createdAt");
      }
      this.createdAt = createdAt;
      return this;
    }
    @Override
    public JobTriggerDto.Builder updatedAt(DateTime updatedAt) {
      if (updatedAt == null) {
        throw new NullPointerException("Null updatedAt");
      }
      this.updatedAt = updatedAt;
      return this;
    }
    @Override
    public JobTriggerDto.Builder triggeredAt(@Nullable DateTime triggeredAt) {
      this.triggeredAt = Optional.ofNullable(triggeredAt);
      return this;
    }
    @Override
    public JobTriggerDto.Builder status(JobTriggerStatus status) {
      if (status == null) {
        throw new NullPointerException("Null status");
      }
      this.status = status;
      return this;
    }
    @Override
    public JobTriggerDto.Builder lock(JobTriggerLock lock) {
      if (lock == null) {
        throw new NullPointerException("Null lock");
      }
      this.lock = lock;
      return this;
    }
    @Override
    public JobTriggerDto.Builder schedule(JobSchedule schedule) {
      if (schedule == null) {
        throw new NullPointerException("Null schedule");
      }
      this.schedule = schedule;
      return this;
    }
    @Override
    public JobTriggerDto.Builder data(@Nullable JobTriggerData data) {
      this.data = Optional.ofNullable(data);
      return this;
    }
    @Override
    public JobTriggerDto build() {
      String missing = "";
      if (this.jobDefinitionId == null) {
        missing += " jobDefinitionId";
      }
      if (this.startTime == null) {
        missing += " startTime";
      }
      if (this.nextTime == null) {
        missing += " nextTime";
      }
      if (this.createdAt == null) {
        missing += " createdAt";
      }
      if (this.updatedAt == null) {
        missing += " updatedAt";
      }
      if (this.status == null) {
        missing += " status";
      }
      if (this.lock == null) {
        missing += " lock";
      }
      if (this.schedule == null) {
        missing += " schedule";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_JobTriggerDto(
          this.id,
          this.jobDefinitionId,
          this.startTime,
          this.endTime,
          this.nextTime,
          this.createdAt,
          this.updatedAt,
          this.triggeredAt,
          this.status,
          this.lock,
          this.schedule,
          this.data);
    }
  }

}
