package org.graylog.scheduler.rest.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.scheduler.JobSchedule;
import org.graylog.scheduler.JobTriggerData;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CreateJobTriggerRequest extends CreateJobTriggerRequest {

  private final String jobDefinitionId;

  private final DateTime startTime;

  private final Optional<DateTime> endTime;

  private final DateTime nextTime;

  private final JobSchedule schedule;

  private final Optional<JobTriggerData> data;

  private AutoValue_CreateJobTriggerRequest(
      String jobDefinitionId,
      DateTime startTime,
      Optional<DateTime> endTime,
      DateTime nextTime,
      JobSchedule schedule,
      Optional<JobTriggerData> data) {
    this.jobDefinitionId = jobDefinitionId;
    this.startTime = startTime;
    this.endTime = endTime;
    this.nextTime = nextTime;
    this.schedule = schedule;
    this.data = data;
  }

  @JsonProperty("job_definition_id")
  @Override
  public String jobDefinitionId() {
    return jobDefinitionId;
  }

  @JsonProperty("start_time")
  @Override
  public DateTime startTime() {
    return startTime;
  }

  @JsonProperty("end_time")
  @Override
  public Optional<DateTime> endTime() {
    return endTime;
  }

  @JsonProperty("next_time")
  @Override
  public DateTime nextTime() {
    return nextTime;
  }

  @JsonProperty("schedule")
  @Override
  public JobSchedule schedule() {
    return schedule;
  }

  @JsonProperty("data")
  @Override
  public Optional<JobTriggerData> data() {
    return data;
  }

  @Override
  public String toString() {
    return "CreateJobTriggerRequest{"
        + "jobDefinitionId=" + jobDefinitionId + ", "
        + "startTime=" + startTime + ", "
        + "endTime=" + endTime + ", "
        + "nextTime=" + nextTime + ", "
        + "schedule=" + schedule + ", "
        + "data=" + data
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CreateJobTriggerRequest) {
      CreateJobTriggerRequest that = (CreateJobTriggerRequest) o;
      return this.jobDefinitionId.equals(that.jobDefinitionId())
          && this.startTime.equals(that.startTime())
          && this.endTime.equals(that.endTime())
          && this.nextTime.equals(that.nextTime())
          && this.schedule.equals(that.schedule())
          && this.data.equals(that.data());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= jobDefinitionId.hashCode();
    h$ *= 1000003;
    h$ ^= startTime.hashCode();
    h$ *= 1000003;
    h$ ^= endTime.hashCode();
    h$ *= 1000003;
    h$ ^= nextTime.hashCode();
    h$ *= 1000003;
    h$ ^= schedule.hashCode();
    h$ *= 1000003;
    h$ ^= data.hashCode();
    return h$;
  }

  @Override
  public CreateJobTriggerRequest.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends CreateJobTriggerRequest.Builder {
    private String jobDefinitionId;
    private DateTime startTime;
    private Optional<DateTime> endTime = Optional.empty();
    private DateTime nextTime;
    private JobSchedule schedule;
    private Optional<JobTriggerData> data = Optional.empty();
    Builder() {
    }
    private Builder(CreateJobTriggerRequest source) {
      this.jobDefinitionId = source.jobDefinitionId();
      this.startTime = source.startTime();
      this.endTime = source.endTime();
      this.nextTime = source.nextTime();
      this.schedule = source.schedule();
      this.data = source.data();
    }
    @Override
    public CreateJobTriggerRequest.Builder jobDefinitionId(String jobDefinitionId) {
      if (jobDefinitionId == null) {
        throw new NullPointerException("Null jobDefinitionId");
      }
      this.jobDefinitionId = jobDefinitionId;
      return this;
    }
    @Override
    public CreateJobTriggerRequest.Builder startTime(DateTime startTime) {
      if (startTime == null) {
        throw new NullPointerException("Null startTime");
      }
      this.startTime = startTime;
      return this;
    }
    @Override
    public CreateJobTriggerRequest.Builder endTime(@Nullable DateTime endTime) {
      this.endTime = Optional.ofNullable(endTime);
      return this;
    }
    @Override
    public CreateJobTriggerRequest.Builder nextTime(DateTime nextTime) {
      if (nextTime == null) {
        throw new NullPointerException("Null nextTime");
      }
      this.nextTime = nextTime;
      return this;
    }
    @Override
    public CreateJobTriggerRequest.Builder schedule(JobSchedule schedule) {
      if (schedule == null) {
        throw new NullPointerException("Null schedule");
      }
      this.schedule = schedule;
      return this;
    }
    @Override
    public CreateJobTriggerRequest.Builder data(@Nullable JobTriggerData data) {
      this.data = Optional.ofNullable(data);
      return this;
    }
    @Override
    public CreateJobTriggerRequest build() {
      String missing = "";
      if (this.jobDefinitionId == null) {
        missing += " jobDefinitionId";
      }
      if (this.startTime == null) {
        missing += " startTime";
      }
      if (this.nextTime == null) {
        missing += " nextTime";
      }
      if (this.schedule == null) {
        missing += " schedule";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CreateJobTriggerRequest(
          this.jobDefinitionId,
          this.startTime,
          this.endTime,
          this.nextTime,
          this.schedule,
          this.data);
    }
  }

}
