package org.graylog.scheduler.schedule;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import javax.validation.constraints.Min;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_IntervalJobSchedule extends IntervalJobSchedule {

  private final String type;

  private final @Min(1L) long interval;

  private final TimeUnit unit;

  private AutoValue_IntervalJobSchedule(
      String type,
      @Min(1L) long interval,
      TimeUnit unit) {
    this.type = type;
    this.interval = interval;
    this.unit = unit;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("interval")
  @Override
  public @Min(1L) long interval() {
    return interval;
  }

  @JsonProperty("unit")
  @Override
  public TimeUnit unit() {
    return unit;
  }

  @Override
  public String toString() {
    return "IntervalJobSchedule{"
        + "type=" + type + ", "
        + "interval=" + interval + ", "
        + "unit=" + unit
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IntervalJobSchedule) {
      IntervalJobSchedule that = (IntervalJobSchedule) o;
      return this.type.equals(that.type())
          && this.interval == that.interval()
          && this.unit.equals(that.unit());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((interval >>> 32) ^ interval);
    h$ *= 1000003;
    h$ ^= unit.hashCode();
    return h$;
  }

  @Override
  public IntervalJobSchedule.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends IntervalJobSchedule.Builder {
    private String type;
    private Long interval;
    private TimeUnit unit;
    Builder() {
    }
    private Builder(IntervalJobSchedule source) {
      this.type = source.type();
      this.interval = source.interval();
      this.unit = source.unit();
    }
    @Override
    public IntervalJobSchedule.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public IntervalJobSchedule.Builder interval(long interval) {
      this.interval = interval;
      return this;
    }
    @Override
    public IntervalJobSchedule.Builder unit(TimeUnit unit) {
      if (unit == null) {
        throw new NullPointerException("Null unit");
      }
      this.unit = unit;
      return this;
    }
    @Override
    IntervalJobSchedule autoBuild() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.interval == null) {
        missing += " interval";
      }
      if (this.unit == null) {
        missing += " unit";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_IntervalJobSchedule(
          this.type,
          this.interval,
          this.unit);
    }
  }

}
