package org.graylog.security.authservice;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_AuthServiceBackendDTO extends AuthServiceBackendDTO {

  private final String id;

  private final String title;

  private final String description;

  private final Set<String> defaultRoles;

  private final @NotNull AuthServiceBackendConfig config;

  $AutoValue_AuthServiceBackendDTO(
      @Nullable String id,
      String title,
      String description,
      Set<String> defaultRoles,
      @NotNull AuthServiceBackendConfig config) {
    this.id = id;
    if (title == null) {
      throw new NullPointerException("Null title");
    }
    this.title = title;
    if (description == null) {
      throw new NullPointerException("Null description");
    }
    this.description = description;
    if (defaultRoles == null) {
      throw new NullPointerException("Null defaultRoles");
    }
    this.defaultRoles = defaultRoles;
    if (config == null) {
      throw new NullPointerException("Null config");
    }
    this.config = config;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("title")
  @Override
  public String title() {
    return title;
  }

  @JsonProperty("description")
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("default_roles")
  @Override
  public Set<String> defaultRoles() {
    return defaultRoles;
  }

  @JsonProperty("config")
  @Override
  public @NotNull AuthServiceBackendConfig config() {
    return config;
  }

  @Override
  public String toString() {
    return "AuthServiceBackendDTO{"
        + "id=" + id + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "defaultRoles=" + defaultRoles + ", "
        + "config=" + config
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AuthServiceBackendDTO) {
      AuthServiceBackendDTO that = (AuthServiceBackendDTO) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.title.equals(that.title())
          && this.description.equals(that.description())
          && this.defaultRoles.equals(that.defaultRoles())
          && this.config.equals(that.config());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= defaultRoles.hashCode();
    h$ *= 1000003;
    h$ ^= config.hashCode();
    return h$;
  }

  @Override
  public AuthServiceBackendDTO.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends AuthServiceBackendDTO.Builder {
    private String id;
    private String title;
    private String description;
    private Set<String> defaultRoles;
    private @NotNull AuthServiceBackendConfig config;
    Builder() {
    }
    private Builder(AuthServiceBackendDTO source) {
      this.id = source.id();
      this.title = source.title();
      this.description = source.description();
      this.defaultRoles = source.defaultRoles();
      this.config = source.config();
    }
    @Override
    public AuthServiceBackendDTO.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public AuthServiceBackendDTO.Builder title(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public AuthServiceBackendDTO.Builder description(String description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public AuthServiceBackendDTO.Builder defaultRoles(Set<String> defaultRoles) {
      if (defaultRoles == null) {
        throw new NullPointerException("Null defaultRoles");
      }
      this.defaultRoles = defaultRoles;
      return this;
    }
    @Override
    public AuthServiceBackendDTO.Builder config(AuthServiceBackendConfig config) {
      if (config == null) {
        throw new NullPointerException("Null config");
      }
      this.config = config;
      return this;
    }
    @Override
    public AuthServiceBackendDTO build() {
      String missing = "";
      if (this.title == null) {
        missing += " title";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (this.defaultRoles == null) {
        missing += " defaultRoles";
      }
      if (this.config == null) {
        missing += " config";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AuthServiceBackendDTO(
          this.id,
          this.title,
          this.description,
          this.defaultRoles,
          this.config);
    }
  }

}
