package org.graylog.security.authservice.ldap;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LDAPEntry extends LDAPEntry {

  private final String dn;

  private final String base64UniqueId;

  private final ImmutableSet<String> objectClasses;

  private final ImmutableListMultimap<String, String> attributes;

  private AutoValue_LDAPEntry(
      String dn,
      String base64UniqueId,
      ImmutableSet<String> objectClasses,
      ImmutableListMultimap<String, String> attributes) {
    this.dn = dn;
    this.base64UniqueId = base64UniqueId;
    this.objectClasses = objectClasses;
    this.attributes = attributes;
  }

  @Override
  public String dn() {
    return dn;
  }

  @Override
  public String base64UniqueId() {
    return base64UniqueId;
  }

  @Override
  public ImmutableSet<String> objectClasses() {
    return objectClasses;
  }

  @Override
  public ImmutableListMultimap<String, String> attributes() {
    return attributes;
  }

  @Override
  public String toString() {
    return "LDAPEntry{"
        + "dn=" + dn + ", "
        + "base64UniqueId=" + base64UniqueId + ", "
        + "objectClasses=" + objectClasses + ", "
        + "attributes=" + attributes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LDAPEntry) {
      LDAPEntry that = (LDAPEntry) o;
      return this.dn.equals(that.dn())
          && this.base64UniqueId.equals(that.base64UniqueId())
          && this.objectClasses.equals(that.objectClasses())
          && this.attributes.equals(that.attributes());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= dn.hashCode();
    h$ *= 1000003;
    h$ ^= base64UniqueId.hashCode();
    h$ *= 1000003;
    h$ ^= objectClasses.hashCode();
    h$ *= 1000003;
    h$ ^= attributes.hashCode();
    return h$;
  }

  static final class Builder extends LDAPEntry.Builder {
    private String dn;
    private String base64UniqueId;
    private ImmutableSet<String> objectClasses;
    private ImmutableListMultimap.Builder<String, String> attributesBuilder$;
    private ImmutableListMultimap<String, String> attributes;
    Builder() {
    }
    @Override
    public LDAPEntry.Builder dn(String dn) {
      if (dn == null) {
        throw new NullPointerException("Null dn");
      }
      this.dn = dn;
      return this;
    }
    @Override
    public LDAPEntry.Builder base64UniqueId(String base64UniqueId) {
      if (base64UniqueId == null) {
        throw new NullPointerException("Null base64UniqueId");
      }
      this.base64UniqueId = base64UniqueId;
      return this;
    }
    @Override
    public LDAPEntry.Builder objectClasses(Collection<String> objectClasses) {
      this.objectClasses = ImmutableSet.copyOf(objectClasses);
      return this;
    }
    @Override
    public ImmutableListMultimap.Builder<String, String> attributesBuilder() {
      if (attributesBuilder$ == null) {
        attributesBuilder$ = ImmutableListMultimap.builder();
      }
      return attributesBuilder$;
    }
    @Override
    public LDAPEntry build() {
      if (attributesBuilder$ != null) {
        this.attributes = attributesBuilder$.build();
      } else if (this.attributes == null) {
        this.attributes = ImmutableListMultimap.of();
      }
      String missing = "";
      if (this.dn == null) {
        missing += " dn";
      }
      if (this.base64UniqueId == null) {
        missing += " base64UniqueId";
      }
      if (this.objectClasses == null) {
        missing += " objectClasses";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LDAPEntry(
          this.dn,
          this.base64UniqueId,
          this.objectClasses,
          this.attributes);
    }
  }

}
