package org.graylog.security.authzroles;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AuthzRoleDTO extends AuthzRoleDTO {

  private final String id;

  private final String name;

  private final String description;

  private final Set<String> permissions;

  private final boolean readOnly;

  private AutoValue_AuthzRoleDTO(
      @Nullable String id,
      String name,
      @Nullable String description,
      Set<String> permissions,
      boolean readOnly) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.permissions = permissions;
    this.readOnly = readOnly;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  @JsonProperty("description")
  @Nullable
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("permissions")
  @Override
  public Set<String> permissions() {
    return permissions;
  }

  @JsonProperty("read_only")
  @Override
  public boolean readOnly() {
    return readOnly;
  }

  @Override
  public String toString() {
    return "AuthzRoleDTO{"
        + "id=" + id + ", "
        + "name=" + name + ", "
        + "description=" + description + ", "
        + "permissions=" + permissions + ", "
        + "readOnly=" + readOnly
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AuthzRoleDTO) {
      AuthzRoleDTO that = (AuthzRoleDTO) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.name.equals(that.name())
          && (this.description == null ? that.description() == null : this.description.equals(that.description()))
          && this.permissions.equals(that.permissions())
          && this.readOnly == that.readOnly();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= permissions.hashCode();
    h$ *= 1000003;
    h$ ^= readOnly ? 1231 : 1237;
    return h$;
  }

  @Override
  public AuthzRoleDTO.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AuthzRoleDTO.Builder {
    private String id;
    private String name;
    private String description;
    private Set<String> permissions;
    private Boolean readOnly;
    Builder() {
    }
    private Builder(AuthzRoleDTO source) {
      this.id = source.id();
      this.name = source.name();
      this.description = source.description();
      this.permissions = source.permissions();
      this.readOnly = source.readOnly();
    }
    @Override
    public AuthzRoleDTO.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public AuthzRoleDTO.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public AuthzRoleDTO.Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }
    @Override
    public AuthzRoleDTO.Builder permissions(Set<String> permissions) {
      if (permissions == null) {
        throw new NullPointerException("Null permissions");
      }
      this.permissions = permissions;
      return this;
    }
    @Override
    public AuthzRoleDTO.Builder readOnly(boolean readOnly) {
      this.readOnly = readOnly;
      return this;
    }
    @Override
    public AuthzRoleDTO build() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.permissions == null) {
        missing += " permissions";
      }
      if (this.readOnly == null) {
        missing += " readOnly";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AuthzRoleDTO(
          this.id,
          this.name,
          this.description,
          this.permissions,
          this.readOnly);
    }
  }

}
