package org.graylog.security.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Generated;
import org.graylog.grn.GRN;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EntityDescriptor extends EntityDescriptor {

  private final GRN id;

  private final String title;

  private final ImmutableSet<EntityDescriptor.Owner> owners;

  private AutoValue_EntityDescriptor(
      GRN id,
      String title,
      ImmutableSet<EntityDescriptor.Owner> owners) {
    this.id = id;
    this.title = title;
    this.owners = owners;
  }

  @JsonProperty("id")
  @Override
  public GRN id() {
    return id;
  }

  @JsonProperty("title")
  @Override
  public String title() {
    return title;
  }

  @JsonProperty("owners")
  @Override
  public ImmutableSet<EntityDescriptor.Owner> owners() {
    return owners;
  }

  @Override
  public String toString() {
    return "EntityDescriptor{"
        + "id=" + id + ", "
        + "title=" + title + ", "
        + "owners=" + owners
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EntityDescriptor) {
      EntityDescriptor that = (EntityDescriptor) o;
      return this.id.equals(that.id())
          && this.title.equals(that.title())
          && this.owners.equals(that.owners());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= owners.hashCode();
    return h$;
  }

  @Override
  public EntityDescriptor.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EntityDescriptor.Builder {
    private GRN id;
    private String title;
    private ImmutableSet<EntityDescriptor.Owner> owners;
    Builder() {
    }
    private Builder(EntityDescriptor source) {
      this.id = source.id();
      this.title = source.title();
      this.owners = source.owners();
    }
    @Override
    public EntityDescriptor.Builder id(GRN id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public EntityDescriptor.Builder title(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public EntityDescriptor.Builder owners(Set<EntityDescriptor.Owner> owners) {
      this.owners = ImmutableSet.copyOf(owners);
      return this;
    }
    @Override
    public EntityDescriptor build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.title == null) {
        missing += " title";
      }
      if (this.owners == null) {
        missing += " owners";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EntityDescriptor(
          this.id,
          this.title,
          this.owners);
    }
  }

}
