package org.graylog.security.events;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import org.graylog.grn.GRN;
import org.graylog2.plugin.database.users.User;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EntitySharesUpdateEvent extends EntitySharesUpdateEvent {

  private final User user;

  private final GRN entity;

  private final ImmutableList<EntitySharesUpdateEvent.Share> creates;

  private final ImmutableList<EntitySharesUpdateEvent.Share> deletes;

  private final ImmutableList<EntitySharesUpdateEvent.Share> updates;

  private AutoValue_EntitySharesUpdateEvent(
      User user,
      GRN entity,
      ImmutableList<EntitySharesUpdateEvent.Share> creates,
      ImmutableList<EntitySharesUpdateEvent.Share> deletes,
      ImmutableList<EntitySharesUpdateEvent.Share> updates) {
    this.user = user;
    this.entity = entity;
    this.creates = creates;
    this.deletes = deletes;
    this.updates = updates;
  }

  @Override
  public User user() {
    return user;
  }

  @Override
  public GRN entity() {
    return entity;
  }

  @Override
  public ImmutableList<EntitySharesUpdateEvent.Share> creates() {
    return creates;
  }

  @Override
  public ImmutableList<EntitySharesUpdateEvent.Share> deletes() {
    return deletes;
  }

  @Override
  public ImmutableList<EntitySharesUpdateEvent.Share> updates() {
    return updates;
  }

  @Override
  public String toString() {
    return "EntitySharesUpdateEvent{"
        + "user=" + user + ", "
        + "entity=" + entity + ", "
        + "creates=" + creates + ", "
        + "deletes=" + deletes + ", "
        + "updates=" + updates
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EntitySharesUpdateEvent) {
      EntitySharesUpdateEvent that = (EntitySharesUpdateEvent) o;
      return this.user.equals(that.user())
          && this.entity.equals(that.entity())
          && this.creates.equals(that.creates())
          && this.deletes.equals(that.deletes())
          && this.updates.equals(that.updates());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= user.hashCode();
    h$ *= 1000003;
    h$ ^= entity.hashCode();
    h$ *= 1000003;
    h$ ^= creates.hashCode();
    h$ *= 1000003;
    h$ ^= deletes.hashCode();
    h$ *= 1000003;
    h$ ^= updates.hashCode();
    return h$;
  }

  static final class Builder extends EntitySharesUpdateEvent.Builder {
    private User user;
    private GRN entity;
    private ImmutableList.Builder<EntitySharesUpdateEvent.Share> createsBuilder$;
    private ImmutableList<EntitySharesUpdateEvent.Share> creates;
    private ImmutableList.Builder<EntitySharesUpdateEvent.Share> deletesBuilder$;
    private ImmutableList<EntitySharesUpdateEvent.Share> deletes;
    private ImmutableList.Builder<EntitySharesUpdateEvent.Share> updatesBuilder$;
    private ImmutableList<EntitySharesUpdateEvent.Share> updates;
    Builder() {
    }
    @Override
    public EntitySharesUpdateEvent.Builder user(User user) {
      if (user == null) {
        throw new NullPointerException("Null user");
      }
      this.user = user;
      return this;
    }
    @Override
    public EntitySharesUpdateEvent.Builder entity(GRN entity) {
      if (entity == null) {
        throw new NullPointerException("Null entity");
      }
      this.entity = entity;
      return this;
    }
    @Override
    public EntitySharesUpdateEvent.Builder creates(List<EntitySharesUpdateEvent.Share> creates) {
      if (createsBuilder$ != null) {
        throw new IllegalStateException("Cannot set creates after calling createsBuilder()");
      }
      this.creates = ImmutableList.copyOf(creates);
      return this;
    }
    @Override
    public ImmutableList.Builder<EntitySharesUpdateEvent.Share> createsBuilder() {
      if (createsBuilder$ == null) {
        if (creates == null) {
          createsBuilder$ = ImmutableList.builder();
        } else {
          createsBuilder$ = ImmutableList.builder();
          createsBuilder$.addAll(creates);
          creates = null;
        }
      }
      return createsBuilder$;
    }
    @Override
    public EntitySharesUpdateEvent.Builder deletes(List<EntitySharesUpdateEvent.Share> deletes) {
      if (deletesBuilder$ != null) {
        throw new IllegalStateException("Cannot set deletes after calling deletesBuilder()");
      }
      this.deletes = ImmutableList.copyOf(deletes);
      return this;
    }
    @Override
    public ImmutableList.Builder<EntitySharesUpdateEvent.Share> deletesBuilder() {
      if (deletesBuilder$ == null) {
        if (deletes == null) {
          deletesBuilder$ = ImmutableList.builder();
        } else {
          deletesBuilder$ = ImmutableList.builder();
          deletesBuilder$.addAll(deletes);
          deletes = null;
        }
      }
      return deletesBuilder$;
    }
    @Override
    public EntitySharesUpdateEvent.Builder updates(List<EntitySharesUpdateEvent.Share> updates) {
      if (updatesBuilder$ != null) {
        throw new IllegalStateException("Cannot set updates after calling updatesBuilder()");
      }
      this.updates = ImmutableList.copyOf(updates);
      return this;
    }
    @Override
    public ImmutableList.Builder<EntitySharesUpdateEvent.Share> updatesBuilder() {
      if (updatesBuilder$ == null) {
        if (updates == null) {
          updatesBuilder$ = ImmutableList.builder();
        } else {
          updatesBuilder$ = ImmutableList.builder();
          updatesBuilder$.addAll(updates);
          updates = null;
        }
      }
      return updatesBuilder$;
    }
    @Override
    public EntitySharesUpdateEvent build() {
      if (createsBuilder$ != null) {
        this.creates = createsBuilder$.build();
      } else if (this.creates == null) {
        this.creates = ImmutableList.of();
      }
      if (deletesBuilder$ != null) {
        this.deletes = deletesBuilder$.build();
      } else if (this.deletes == null) {
        this.deletes = ImmutableList.of();
      }
      if (updatesBuilder$ != null) {
        this.updates = updatesBuilder$.build();
      } else if (this.updates == null) {
        this.updates = ImmutableList.of();
      }
      String missing = "";
      if (this.user == null) {
        missing += " user";
      }
      if (this.entity == null) {
        missing += " entity";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EntitySharesUpdateEvent(
          this.user,
          this.entity,
          this.creates,
          this.deletes,
          this.updates);
    }
  }

}
