package org.graylog.security.shares;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import org.graylog.grn.GRN;
import org.graylog.security.Capability;
import org.graylog.security.entities.EntityDescriptor;
import org.graylog2.plugin.rest.ValidationResult;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EntityShareResponse extends EntityShareResponse {

  private final String entity;

  private final GRN sharingUser;

  private final ImmutableSet<EntityShareResponse.AvailableGrantee> availableGrantees;

  private final ImmutableSet<EntityShareResponse.AvailableCapability> availableCapabilities;

  private final ImmutableSet<EntityShareResponse.ActiveShare> activeShares;

  private final ImmutableMap<GRN, Capability> selectedGranteeCapabilities;

  private final ImmutableMap<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies;

  private final ValidationResult validationResult;

  private AutoValue_EntityShareResponse(
      String entity,
      GRN sharingUser,
      ImmutableSet<EntityShareResponse.AvailableGrantee> availableGrantees,
      ImmutableSet<EntityShareResponse.AvailableCapability> availableCapabilities,
      ImmutableSet<EntityShareResponse.ActiveShare> activeShares,
      ImmutableMap<GRN, Capability> selectedGranteeCapabilities,
      ImmutableMap<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies,
      ValidationResult validationResult) {
    this.entity = entity;
    this.sharingUser = sharingUser;
    this.availableGrantees = availableGrantees;
    this.availableCapabilities = availableCapabilities;
    this.activeShares = activeShares;
    this.selectedGranteeCapabilities = selectedGranteeCapabilities;
    this.missingPermissionsOnDependencies = missingPermissionsOnDependencies;
    this.validationResult = validationResult;
  }

  @JsonProperty("entity")
  @Override
  public String entity() {
    return entity;
  }

  @JsonProperty("sharing_user")
  @Override
  public GRN sharingUser() {
    return sharingUser;
  }

  @JsonProperty("available_grantees")
  @Override
  public ImmutableSet<EntityShareResponse.AvailableGrantee> availableGrantees() {
    return availableGrantees;
  }

  @JsonProperty("available_capabilities")
  @Override
  public ImmutableSet<EntityShareResponse.AvailableCapability> availableCapabilities() {
    return availableCapabilities;
  }

  @JsonProperty("active_shares")
  @Override
  public ImmutableSet<EntityShareResponse.ActiveShare> activeShares() {
    return activeShares;
  }

  @JsonProperty("selected_grantee_capabilities")
  @Override
  public ImmutableMap<GRN, Capability> selectedGranteeCapabilities() {
    return selectedGranteeCapabilities;
  }

  @JsonProperty("missing_permissions_on_dependencies")
  @Override
  public ImmutableMap<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies() {
    return missingPermissionsOnDependencies;
  }

  @JsonProperty("validation_result")
  @Override
  public ValidationResult validationResult() {
    return validationResult;
  }

  @Override
  public String toString() {
    return "EntityShareResponse{"
        + "entity=" + entity + ", "
        + "sharingUser=" + sharingUser + ", "
        + "availableGrantees=" + availableGrantees + ", "
        + "availableCapabilities=" + availableCapabilities + ", "
        + "activeShares=" + activeShares + ", "
        + "selectedGranteeCapabilities=" + selectedGranteeCapabilities + ", "
        + "missingPermissionsOnDependencies=" + missingPermissionsOnDependencies + ", "
        + "validationResult=" + validationResult
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EntityShareResponse) {
      EntityShareResponse that = (EntityShareResponse) o;
      return this.entity.equals(that.entity())
          && this.sharingUser.equals(that.sharingUser())
          && this.availableGrantees.equals(that.availableGrantees())
          && this.availableCapabilities.equals(that.availableCapabilities())
          && this.activeShares.equals(that.activeShares())
          && this.selectedGranteeCapabilities.equals(that.selectedGranteeCapabilities())
          && this.missingPermissionsOnDependencies.equals(that.missingPermissionsOnDependencies())
          && this.validationResult.equals(that.validationResult());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= entity.hashCode();
    h$ *= 1000003;
    h$ ^= sharingUser.hashCode();
    h$ *= 1000003;
    h$ ^= availableGrantees.hashCode();
    h$ *= 1000003;
    h$ ^= availableCapabilities.hashCode();
    h$ *= 1000003;
    h$ ^= activeShares.hashCode();
    h$ *= 1000003;
    h$ ^= selectedGranteeCapabilities.hashCode();
    h$ *= 1000003;
    h$ ^= missingPermissionsOnDependencies.hashCode();
    h$ *= 1000003;
    h$ ^= validationResult.hashCode();
    return h$;
  }

  static final class Builder extends EntityShareResponse.Builder {
    private String entity;
    private GRN sharingUser;
    private ImmutableSet<EntityShareResponse.AvailableGrantee> availableGrantees;
    private ImmutableSet<EntityShareResponse.AvailableCapability> availableCapabilities;
    private ImmutableSet<EntityShareResponse.ActiveShare> activeShares;
    private ImmutableMap<GRN, Capability> selectedGranteeCapabilities;
    private ImmutableMap<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies;
    private ValidationResult validationResult;
    Builder() {
    }
    @Override
    public EntityShareResponse.Builder entity(String entity) {
      if (entity == null) {
        throw new NullPointerException("Null entity");
      }
      this.entity = entity;
      return this;
    }
    @Override
    public EntityShareResponse.Builder sharingUser(GRN sharingUser) {
      if (sharingUser == null) {
        throw new NullPointerException("Null sharingUser");
      }
      this.sharingUser = sharingUser;
      return this;
    }
    @Override
    public EntityShareResponse.Builder availableGrantees(Set<EntityShareResponse.AvailableGrantee> availableGrantees) {
      this.availableGrantees = ImmutableSet.copyOf(availableGrantees);
      return this;
    }
    @Override
    public EntityShareResponse.Builder availableCapabilities(Set<EntityShareResponse.AvailableCapability> availableCapabilities) {
      this.availableCapabilities = ImmutableSet.copyOf(availableCapabilities);
      return this;
    }
    @Override
    public EntityShareResponse.Builder activeShares(Set<EntityShareResponse.ActiveShare> activeShares) {
      this.activeShares = ImmutableSet.copyOf(activeShares);
      return this;
    }
    @Override
    public EntityShareResponse.Builder selectedGranteeCapabilities(Map<GRN, Capability> selectedGranteeCapabilities) {
      this.selectedGranteeCapabilities = ImmutableMap.copyOf(selectedGranteeCapabilities);
      return this;
    }
    @Override
    public EntityShareResponse.Builder missingPermissionsOnDependencies(Map<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies) {
      this.missingPermissionsOnDependencies = ImmutableMap.copyOf(missingPermissionsOnDependencies);
      return this;
    }
    @Override
    public EntityShareResponse.Builder validationResult(ValidationResult validationResult) {
      if (validationResult == null) {
        throw new NullPointerException("Null validationResult");
      }
      this.validationResult = validationResult;
      return this;
    }
    @Override
    public EntityShareResponse build() {
      String missing = "";
      if (this.entity == null) {
        missing += " entity";
      }
      if (this.sharingUser == null) {
        missing += " sharingUser";
      }
      if (this.availableGrantees == null) {
        missing += " availableGrantees";
      }
      if (this.availableCapabilities == null) {
        missing += " availableCapabilities";
      }
      if (this.activeShares == null) {
        missing += " activeShares";
      }
      if (this.selectedGranteeCapabilities == null) {
        missing += " selectedGranteeCapabilities";
      }
      if (this.missingPermissionsOnDependencies == null) {
        missing += " missingPermissionsOnDependencies";
      }
      if (this.validationResult == null) {
        missing += " validationResult";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EntityShareResponse(
          this.entity,
          this.sharingUser,
          this.availableGrantees,
          this.availableCapabilities,
          this.activeShares,
          this.selectedGranteeCapabilities,
          this.missingPermissionsOnDependencies,
          this.validationResult);
    }
  }

}
