package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Generated;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelVersion;
import org.graylog2.contentpacks.model.constraints.Constraint;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EntityV1 extends EntityV1 {

  private final ModelId id;

  private final ModelType type;

  private final ModelVersion version;

  private final JsonNode data;

  private final ImmutableSet<Constraint> constraints;

  private AutoValue_EntityV1(
      ModelId id,
      ModelType type,
      ModelVersion version,
      JsonNode data,
      ImmutableSet<Constraint> constraints) {
    this.id = id;
    this.type = type;
    this.version = version;
    this.data = data;
    this.constraints = constraints;
  }

  @JsonProperty("id")
  @Override
  public ModelId id() {
    return id;
  }

  @JsonProperty("type")
  @Override
  public ModelType type() {
    return type;
  }

  @JsonProperty("v")
  @Override
  public ModelVersion version() {
    return version;
  }

  @JsonProperty("data")
  @Override
  public JsonNode data() {
    return data;
  }

  @JsonProperty("constraints")
  @Override
  public ImmutableSet<Constraint> constraints() {
    return constraints;
  }

  @Override
  public String toString() {
    return "EntityV1{"
        + "id=" + id + ", "
        + "type=" + type + ", "
        + "version=" + version + ", "
        + "data=" + data + ", "
        + "constraints=" + constraints
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EntityV1) {
      EntityV1 that = (EntityV1) o;
      return this.id.equals(that.id())
          && this.type.equals(that.type())
          && this.version.equals(that.version())
          && this.data.equals(that.data())
          && this.constraints.equals(that.constraints());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= version.hashCode();
    h$ *= 1000003;
    h$ ^= data.hashCode();
    h$ *= 1000003;
    h$ ^= constraints.hashCode();
    return h$;
  }

  @Override
  public EntityV1.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EntityV1.Builder {
    private ModelId id;
    private ModelType type;
    private ModelVersion version;
    private JsonNode data;
    private ImmutableSet<Constraint> constraints;
    Builder() {
    }
    private Builder(EntityV1 source) {
      this.id = source.id();
      this.type = source.type();
      this.version = source.version();
      this.data = source.data();
      this.constraints = source.constraints();
    }
    @Override
    public EntityV1.Builder id(ModelId id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public ModelId id() {
      if (id == null) {
        throw new IllegalStateException("Property \"id\" has not been set");
      }
      return id;
    }
    @Override
    public EntityV1.Builder type(ModelType type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public EntityV1.Builder version(ModelVersion version) {
      if (version == null) {
        throw new NullPointerException("Null version");
      }
      this.version = version;
      return this;
    }
    @Override
    public EntityV1.Builder data(JsonNode data) {
      if (data == null) {
        throw new NullPointerException("Null data");
      }
      this.data = data;
      return this;
    }
    @Override
    public EntityV1.Builder constraints(ImmutableSet<Constraint> constraints) {
      if (constraints == null) {
        throw new NullPointerException("Null constraints");
      }
      this.constraints = constraints;
      return this;
    }
    @Override
    EntityV1 autoBuild() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (this.version == null) {
        missing += " version";
      }
      if (this.data == null) {
        missing += " data";
      }
      if (this.constraints == null) {
        missing += " constraints";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EntityV1(
          this.id,
          this.type,
          this.version,
          this.data,
          this.constraints);
    }
  }

}
