package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventListEntity extends EventListEntity {

  private final Optional<String> name;

  private final Optional<DerivedTimeRange> timerange;

  private final Optional<BackendQuery> query;

  private final Set<String> streams;

  private final String type;

  private final String id;

  private final Filter filter;

  private AutoValue_EventListEntity(
      Optional<String> name,
      Optional<DerivedTimeRange> timerange,
      Optional<BackendQuery> query,
      Set<String> streams,
      String type,
      @Nullable String id,
      @Nullable Filter filter) {
    this.name = name;
    this.timerange = timerange;
    this.query = query;
    this.streams = streams;
    this.type = type;
    this.id = id;
    this.filter = filter;
  }

  @JsonProperty
  @Override
  public Optional<String> name() {
    return name;
  }

  @JsonProperty
  @Override
  public Optional<DerivedTimeRange> timerange() {
    return timerange;
  }

  @JsonProperty
  @Override
  public Optional<BackendQuery> query() {
    return query;
  }

  @JsonProperty
  @Override
  public Set<String> streams() {
    return streams;
  }

  @Override
  public String type() {
    return type;
  }

  @Nullable
  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @Nullable
  @Override
  public Filter filter() {
    return filter;
  }

  @Override
  public String toString() {
    return "EventListEntity{"
        + "name=" + name + ", "
        + "timerange=" + timerange + ", "
        + "query=" + query + ", "
        + "streams=" + streams + ", "
        + "type=" + type + ", "
        + "id=" + id + ", "
        + "filter=" + filter
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventListEntity) {
      EventListEntity that = (EventListEntity) o;
      return this.name.equals(that.name())
          && this.timerange.equals(that.timerange())
          && this.query.equals(that.query())
          && this.streams.equals(that.streams())
          && this.type.equals(that.type())
          && (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= (filter == null) ? 0 : filter.hashCode();
    return h$;
  }

  @Override
  public EventListEntity.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventListEntity.Builder {
    private Optional<String> name = Optional.empty();
    private Optional<DerivedTimeRange> timerange = Optional.empty();
    private Optional<BackendQuery> query = Optional.empty();
    private Set<String> streams;
    private String type;
    private String id;
    private Filter filter;
    Builder() {
    }
    private Builder(EventListEntity source) {
      this.name = source.name();
      this.timerange = source.timerange();
      this.query = source.query();
      this.streams = source.streams();
      this.type = source.type();
      this.id = source.id();
      this.filter = source.filter();
    }
    @Override
    public EventListEntity.Builder name(@Nullable String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }
    @Override
    public EventListEntity.Builder timerange(@Nullable DerivedTimeRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    public EventListEntity.Builder query(@Nullable BackendQuery query) {
      this.query = Optional.ofNullable(query);
      return this;
    }
    @Override
    public EventListEntity.Builder streams(Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    public EventListEntity.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public EventListEntity.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public EventListEntity.Builder filter(@Nullable Filter filter) {
      this.filter = filter;
      return this;
    }
    @Override
    public EventListEntity build() {
      String missing = "";
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventListEntity(
          this.name,
          this.timerange,
          this.query,
          this.streams,
          this.type,
          this.id,
          this.filter);
    }
  }

}
