package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_NativeEntityDescriptor extends NativeEntityDescriptor {

  private final ModelId id;

  private final ModelType type;

  private final ModelId contentPackEntityId;

  private final String title;

  private final boolean foundOnSystem;

  private AutoValue_NativeEntityDescriptor(
      ModelId id,
      ModelType type,
      ModelId contentPackEntityId,
      String title,
      boolean foundOnSystem) {
    this.id = id;
    this.type = type;
    this.contentPackEntityId = contentPackEntityId;
    this.title = title;
    this.foundOnSystem = foundOnSystem;
  }

  @JsonProperty("id")
  @Override
  public ModelId id() {
    return id;
  }

  @JsonProperty("type")
  @Override
  public ModelType type() {
    return type;
  }

  @JsonProperty("content_pack_entity_id")
  @Override
  public ModelId contentPackEntityId() {
    return contentPackEntityId;
  }

  @JsonProperty("title")
  @Override
  public String title() {
    return title;
  }

  @JsonProperty("found_on_system")
  @Override
  public boolean foundOnSystem() {
    return foundOnSystem;
  }

  @Override
  public String toString() {
    return "NativeEntityDescriptor{"
        + "id=" + id + ", "
        + "type=" + type + ", "
        + "contentPackEntityId=" + contentPackEntityId + ", "
        + "title=" + title + ", "
        + "foundOnSystem=" + foundOnSystem
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NativeEntityDescriptor) {
      NativeEntityDescriptor that = (NativeEntityDescriptor) o;
      return this.id.equals(that.id())
          && this.type.equals(that.type())
          && this.contentPackEntityId.equals(that.contentPackEntityId())
          && this.title.equals(that.title())
          && this.foundOnSystem == that.foundOnSystem();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= contentPackEntityId.hashCode();
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= foundOnSystem ? 1231 : 1237;
    return h$;
  }

  @Override
  public NativeEntityDescriptor.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends NativeEntityDescriptor.Builder {
    private ModelId id;
    private ModelType type;
    private ModelId contentPackEntityId;
    private String title;
    private Boolean foundOnSystem;
    Builder() {
    }
    private Builder(NativeEntityDescriptor source) {
      this.id = source.id();
      this.type = source.type();
      this.contentPackEntityId = source.contentPackEntityId();
      this.title = source.title();
      this.foundOnSystem = source.foundOnSystem();
    }
    @Override
    public NativeEntityDescriptor.Builder id(ModelId id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public ModelId id() {
      if (id == null) {
        throw new IllegalStateException("Property \"id\" has not been set");
      }
      return id;
    }
    @Override
    public NativeEntityDescriptor.Builder type(ModelType type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    NativeEntityDescriptor.Builder contentPackEntityId(ModelId contentPackEntityId) {
      if (contentPackEntityId == null) {
        throw new NullPointerException("Null contentPackEntityId");
      }
      this.contentPackEntityId = contentPackEntityId;
      return this;
    }
    @Override
    NativeEntityDescriptor.Builder title(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public NativeEntityDescriptor.Builder foundOnSystem(boolean foundOnSystem) {
      this.foundOnSystem = foundOnSystem;
      return this;
    }
    @Override
    public NativeEntityDescriptor build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (this.contentPackEntityId == null) {
        missing += " contentPackEntityId";
      }
      if (this.title == null) {
        missing += " title";
      }
      if (this.foundOnSystem == null) {
        missing += " foundOnSystem";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_NativeEntityDescriptor(
          this.id,
          this.type,
          this.contentPackEntityId,
          this.title,
          this.foundOnSystem);
    }
  }

}
