package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

final class AutoValue_StreamEntity extends $AutoValue_StreamEntity {
  AutoValue_StreamEntity(ValueReference title, ValueReference description, ValueReference disabled,
      ValueReference matchingType, List<StreamRuleEntity> streamRules,
      List<StreamAlertConditionEntity> alertConditions,
      List<StreamAlarmCallbackEntity> alarmCallbacks, Set<ValueReference> outputs,
      ValueReference defaultStream, ValueReference removeMatches) {
    super(title, description, disabled, matchingType, streamRules, alertConditions, alarmCallbacks, outputs, defaultStream, removeMatches);
  }

  @JsonIgnore
  @NotBlank
  public final ValueReference getTitle() {
    return title();
  }

  @JsonIgnore
  public final ValueReference getDescription() {
    return description();
  }

  @JsonIgnore
  public final ValueReference getDisabled() {
    return disabled();
  }

  @JsonIgnore
  public final ValueReference getMatchingType() {
    return matchingType();
  }

  @JsonIgnore
  @NotNull
  public final List<StreamRuleEntity> getStreamRules() {
    return streamRules();
  }

  @JsonIgnore
  @NotNull
  public final List<StreamAlertConditionEntity> getAlertConditions() {
    return alertConditions();
  }

  @JsonIgnore
  @NotNull
  public final List<StreamAlarmCallbackEntity> getAlarmCallbacks() {
    return alarmCallbacks();
  }

  @JsonIgnore
  @NotNull
  public final Set<ValueReference> getOutputs() {
    return outputs();
  }

  @JsonIgnore
  public final ValueReference getDefaultStream() {
    return defaultStream();
  }

  @JsonIgnore
  public final ValueReference getRemoveMatches() {
    return removeMatches();
  }
}
