package org.graylog2.indexer.fieldtypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FieldTypes extends FieldTypes {

  private final String fieldName;

  private final ImmutableSet<FieldTypes.Type> types;

  private AutoValue_FieldTypes(
      String fieldName,
      ImmutableSet<FieldTypes.Type> types) {
    this.fieldName = fieldName;
    this.types = types;
  }

  @JsonProperty("field_name")
  @Override
  public String fieldName() {
    return fieldName;
  }

  @JsonProperty("types")
  @Override
  public ImmutableSet<FieldTypes.Type> types() {
    return types;
  }

  @Override
  public String toString() {
    return "FieldTypes{"
        + "fieldName=" + fieldName + ", "
        + "types=" + types
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FieldTypes) {
      FieldTypes that = (FieldTypes) o;
      return this.fieldName.equals(that.fieldName())
          && this.types.equals(that.types());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= fieldName.hashCode();
    h$ *= 1000003;
    h$ ^= types.hashCode();
    return h$;
  }

  @Override
  public FieldTypes.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends FieldTypes.Builder {
    private String fieldName;
    private ImmutableSet.Builder<FieldTypes.Type> typesBuilder$;
    private ImmutableSet<FieldTypes.Type> types;
    Builder() {
    }
    private Builder(FieldTypes source) {
      this.fieldName = source.fieldName();
      this.types = source.types();
    }
    @Override
    public FieldTypes.Builder fieldName(String fieldName) {
      if (fieldName == null) {
        throw new NullPointerException("Null fieldName");
      }
      this.fieldName = fieldName;
      return this;
    }
    @Override
    ImmutableSet.Builder<FieldTypes.Type> typesBuilder() {
      if (typesBuilder$ == null) {
        if (types == null) {
          typesBuilder$ = ImmutableSet.builder();
        } else {
          typesBuilder$ = ImmutableSet.builder();
          typesBuilder$.addAll(types);
          types = null;
        }
      }
      return typesBuilder$;
    }
    @Override
    public FieldTypes build() {
      if (typesBuilder$ != null) {
        this.types = typesBuilder$.build();
      } else if (this.types == null) {
        this.types = ImmutableSet.of();
      }
      String missing = "";
      if (this.fieldName == null) {
        missing += " fieldName";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FieldTypes(
          this.fieldName,
          this.types);
    }
  }

}
