package org.graylog2.indexer.results;

import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FieldStatsResult extends FieldStatsResult {

  private final long count;

  private final double sum;

  private final double sumOfSquares;

  private final double mean;

  private final double min;

  private final double max;

  private final double variance;

  private final double stdDeviation;

  private final long cardinality;

  private final List<ResultMessage> searchHits;

  private final String originalQuery;

  private final String builtQuery;

  private final long tookMs;

  AutoValue_FieldStatsResult(
      long count,
      double sum,
      double sumOfSquares,
      double mean,
      double min,
      double max,
      double variance,
      double stdDeviation,
      long cardinality,
      List<ResultMessage> searchHits,
      @Nullable String originalQuery,
      @Nullable String builtQuery,
      long tookMs) {
    this.count = count;
    this.sum = sum;
    this.sumOfSquares = sumOfSquares;
    this.mean = mean;
    this.min = min;
    this.max = max;
    this.variance = variance;
    this.stdDeviation = stdDeviation;
    this.cardinality = cardinality;
    if (searchHits == null) {
      throw new NullPointerException("Null searchHits");
    }
    this.searchHits = searchHits;
    this.originalQuery = originalQuery;
    this.builtQuery = builtQuery;
    this.tookMs = tookMs;
  }

  @Override
  public long count() {
    return count;
  }

  @Override
  public double sum() {
    return sum;
  }

  @Override
  public double sumOfSquares() {
    return sumOfSquares;
  }

  @Override
  public double mean() {
    return mean;
  }

  @Override
  public double min() {
    return min;
  }

  @Override
  public double max() {
    return max;
  }

  @Override
  public double variance() {
    return variance;
  }

  @Override
  public double stdDeviation() {
    return stdDeviation;
  }

  @Override
  public long cardinality() {
    return cardinality;
  }

  @Override
  public List<ResultMessage> searchHits() {
    return searchHits;
  }

  @Nullable
  @Override
  public String originalQuery() {
    return originalQuery;
  }

  @Nullable
  @Override
  public String builtQuery() {
    return builtQuery;
  }

  @Override
  public long tookMs() {
    return tookMs;
  }

  @Override
  public String toString() {
    return "FieldStatsResult{"
        + "count=" + count + ", "
        + "sum=" + sum + ", "
        + "sumOfSquares=" + sumOfSquares + ", "
        + "mean=" + mean + ", "
        + "min=" + min + ", "
        + "max=" + max + ", "
        + "variance=" + variance + ", "
        + "stdDeviation=" + stdDeviation + ", "
        + "cardinality=" + cardinality + ", "
        + "searchHits=" + searchHits + ", "
        + "originalQuery=" + originalQuery + ", "
        + "builtQuery=" + builtQuery + ", "
        + "tookMs=" + tookMs
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FieldStatsResult) {
      FieldStatsResult that = (FieldStatsResult) o;
      return this.count == that.count()
          && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(that.sum())
          && Double.doubleToLongBits(this.sumOfSquares) == Double.doubleToLongBits(that.sumOfSquares())
          && Double.doubleToLongBits(this.mean) == Double.doubleToLongBits(that.mean())
          && Double.doubleToLongBits(this.min) == Double.doubleToLongBits(that.min())
          && Double.doubleToLongBits(this.max) == Double.doubleToLongBits(that.max())
          && Double.doubleToLongBits(this.variance) == Double.doubleToLongBits(that.variance())
          && Double.doubleToLongBits(this.stdDeviation) == Double.doubleToLongBits(that.stdDeviation())
          && this.cardinality == that.cardinality()
          && this.searchHits.equals(that.searchHits())
          && (this.originalQuery == null ? that.originalQuery() == null : this.originalQuery.equals(that.originalQuery()))
          && (this.builtQuery == null ? that.builtQuery() == null : this.builtQuery.equals(that.builtQuery()))
          && this.tookMs == that.tookMs();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (int) ((count >>> 32) ^ count);
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(sum) >>> 32) ^ Double.doubleToLongBits(sum));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(sumOfSquares) >>> 32) ^ Double.doubleToLongBits(sumOfSquares));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(mean) >>> 32) ^ Double.doubleToLongBits(mean));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(min) >>> 32) ^ Double.doubleToLongBits(min));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(max) >>> 32) ^ Double.doubleToLongBits(max));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(variance) >>> 32) ^ Double.doubleToLongBits(variance));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(stdDeviation) >>> 32) ^ Double.doubleToLongBits(stdDeviation));
    h$ *= 1000003;
    h$ ^= (int) ((cardinality >>> 32) ^ cardinality);
    h$ *= 1000003;
    h$ ^= searchHits.hashCode();
    h$ *= 1000003;
    h$ ^= (originalQuery == null) ? 0 : originalQuery.hashCode();
    h$ *= 1000003;
    h$ ^= (builtQuery == null) ? 0 : builtQuery.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((tookMs >>> 32) ^ tookMs);
    return h$;
  }

}
